use hahn;
pragma AnsiInForEmptyOrNullableItemsCollections;

$input_table = "//logs/bs-hit-log/1d/" || $date;
$inapp = "//home/bs/users/yabs-analytics/video/pageimp_ids_video_with_inapp";
$good_page_imp_ = (
    select pageid, impid, IF(some(video_placement_name) = "instream", "instream", "outstream") as stream_type, IF(some(category) like "%VH%", "vh", "external") as page_type, some(category) as category
    from (
        select
            cast(pageid as String) as pageid,
            cast(impid as String) as impid,
            video_placement_name,
            category
        from $inapp
    )
    group by pageid, impid
);
$good_page_imp = (
    select
        IF(category = "other", Name, category) as category, s.* without s.category
    from $good_page_imp_ as s
    left join any `home/yabs/dict/Page` as p on (cast(p.PageID as String) = s.pageid)
);

$wrap = ($id) -> (IF($id in ("", "0"), null, $id));

$getHost = ($url) -> {
    return Url::GetDomain($url, 2)
};


$parseBSCategories = ($brandsafetycategories, $options) -> {
    return case
    when $options like "%unknown-brand-safety-categories%" then ["all"]
    when $brandsafetycategories like "%,%" then String::SplitToList($brandsafetycategories, ",")
    else null
    end
};

$parseCCInner = ($s) -> (ListNotNull(ListMap(
    String::SplitToList($s,","), ($x)->(CAST($x as UInt64))
)));
$parseCC = ($s) -> {
    return IF(
        $s is not null and ListLength($parseCCInner($s)) > 0, $parseCCInner($s)
    )
};

$hits = (
    select
        contentid,
        urlmd5,
        $getHost(referer) as host,
        referer,
        i.pageid as pageid,
        i.impid as impid,
        $parseBSCategories(brandsafetycategories, options) as hitlog_bs_tags,
        $parseCC(contentcategories) as hitlog_content_categories,
        stream_type,
        page_type,
        category
    from $input_table as i
    inner join any $good_page_imp as g using (pageid, impid)
    where gotproducttypes like "%video-creative-reach%" and (
        $wrap(contentid) is not null or $wrap(cast(urlmd5 as String)) is not null
    )
);



$getCat = ($bs) -> (case
when $bs is null then "null"
when $bs = ["all"] then "all"
else cast(ListLength($bs) as String)
end);

$map1 = (
    select
        [
            [stream_type],
            [stream_type, page_type],
            [stream_type, page_type, category],
        ] as identificator,
        $getCat(hitlog_bs_tags) as bs_cat
    from $hits
);

$gr = (
    select
        ListMap(identificator, ($x)->(unwrap($x))) as identificator,
        count(*) as `count`,
        count_if(bs_cat in ("null", "0")) as bs_tags_ok,
        count_if(bs_cat = "all") as bs_tags_all,
        count_if(bs_cat not in ("null", "0", "all")) as bs_tags_some,
    from $map1
    flatten list by identificator
    group by identificator
);

$gr12 = (
    select * from $gr where ListLength(identificator) < 3
);

$gr3 = (
    select ListTake(identificator, 2) as ident2, s.* from $gr as s where ListLength(identificator) = 3
);

$gr3a = (
    select
        p.`count` as parent_count,
        g.* without g.ident2
    from $gr3 as g
    left join any $gr12 as p on (g.ident2 = p.identificator)
);

$reunite = (
    select * from $gr3a
    union all
    select * from $gr12
);

$for_push = (
    select
        $date as fielddate,
        s.*
    from $reunite as s
    where "vh" in identificator or `count` >= 10000
);

upsert into stat.`Video/Others/Strm/MMA-5298-tree/daily`
select * from $for_push;
