#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import sys
import os
import argparse
import datetime
from nile.api.v1 import clusters
from yql.api.v1.client import YqlClient
from videolog_common import (
    apply_replacements,
    date_range,
    get_cluster,
    get_driver,
    get_stat_headers,
    get_dates_from_stat,
    get_date,
    YqlRunner,
)

TITLE = "[CPMADV-45] CPV Stats | YQL"


def process_date(date, args):
    proxy = os.environ["YT_PROXY"]
    yc = YqlClient(db=proxy.lower(), token=os.environ["YQL_TOKEN"])
    yr = YqlRunner(client=yc, title=TITLE)
    with open("cpmadv_45_cpv_stats_stub.sql", "rb") as f:
        query = f.read().decode("utf8")
    query = "$date = \"{date}\";\n".format(date=date) + query
    yr.run(query, wait=True)

LOG_ROOTS = [
    "//cooked_logs/bs-chevent-cooked-log/1d",
    "//logs/bs-chtracking-log/1d",
]


def get_last_date(yt):
    return max(get_date(x) for x in yt.list("//home/videoquality/vh_analytics/campaigns_cpv"))


def get_available_dates(yt):
    dates = None
    for root in LOG_ROOTS:
        dates_ = {get_date(x) for x in yt.search(root) if get_date(x)}
        if dates is None:
            dates = dates_
        else:
            dates &= dates_
    return dates


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--pool", default="robot-mma-nirvana")
    parser.add_argument("--title", default=TITLE)
    parser.add_argument("--date")
    parser.add_argument("--redo", action="store_true")
    args = vars(parser.parse_args())

    cluster = get_cluster(clusters, args)
    yt = get_driver(cluster).client

    date_to_process = None

    if args["date"]:
        date_to_process = get_date(args["date"])
    else:
        last_date = get_last_date(yt)
        last_available_date = max(
            get_available_dates(yt)
        )
        print("last date: {}".format(last_date))
        print("last available date: {}".format(last_available_date))
        if last_date >= last_available_date:
            print("no dates to process")
            sys.exit(0)
        date_to_process = last_available_date

    if date_to_process:
        process_date(date_to_process, args)
    else:
        print("no dates to process")


if __name__ == "__main__":
    main()
