use hahn;
pragma yt.ParallelOperationsLimit = "4";

$date_from = $date;
$date_to = $date;
$output_root = "//home/videoquality/vh_analytics/campaigns_cpv/";

$parseDate = ($x)->(DateTime::MakeDate(DateTime::Parse("%Y-%m-%d")($x)));
$formatDate = DateTime::Format("%Y-%m-%d");


$dateRange = ($f, $t) -> {
    $f = $parseDate($f);
    $t = $parseDate($t);
    $diff = DateTime::ToDays($t - $f) + 1;
    return ListMap(
        ListFromRange(0, unwrap($diff)),
        ($x)->(
            $formatDate($f + DateTime::IntervalFromDays(cast($x as Int16)))
        )
    )
};

$chevent_map = (
    select
        TableName() as fielddate,
        hitlogid,
        position,
        orderid,
        cast(eventcost as Double) as eventcost
    from range(`cooked_logs/bs-chevent-cooked-log/1d`, $date_from, $date_to)
    where countertype = 1 and fraudbits = 0 and producttype like "%reach%"
);

$chevent_reduce = (
    select
        fielddate,
        hitlogid,
        position,
        some(orderid) as orderid,
        30.0 * sum(eventcost) / 1000.0 / 1000.0 / 1.18 as cost_rub
    from $chevent_map
    group by fielddate, hitlogid, position
);

$chtracking_map = (
    select
        TableName() as fielddate,
        cast(hitlogid as Uint64) as hitlogid,
        cast(position as Uint64) as position,
    from range(`logs/bs-chtracking-log/1d`, $date_from, $date_to)
    where fraudbits = "0" and `action` = "complete"
);

$chtracking_reduce = (
    select
        fielddate, hitlogid, position
    from $chtracking_map
    group by fielddate, hitlogid, position
);

$join_all = (
    SELECT
        c.*,

        IF(ch.hitlogid is not null, 1, 0) as completes
    from $chevent_reduce as c
    left join any $chtracking_reduce as ch on (
        c.fielddate = ch.fielddate
        and c.hitlogid = ch.hitlogid
        and c.position = ch.position
    )
);

$grouped = (
    select
        fielddate,
        orderid,
        count(*) as shows,
        sum(cost_rub) as cost_rub,
        sum(completes) as completes
    from $join_all
    group by fielddate, orderid
);

$join_cid = (
    select
        g.*, cid
    from $grouped as g
    left join any `home/direct/db/campaigns` as c on (g.orderid = c.OrderID)
);

define action $put_into_table($date) as
$output_table = $output_root || $date;
insert into $output_table WITH TRUNCATE
select * from $join_cid where fielddate == $date;
end define;

evaluate for $date_ in $dateRange($date_from, $date_to)
    do $put_into_table($date_);
