#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import sys
import os
import argparse
import datetime
from nile.api.v1 import clusters
from yql.api.v1.client import YqlClient
from videolog_common import (
    apply_replacements,
    date_range,
    get_cluster,
    get_driver,
    get_stat_headers,
    get_dates_from_stat,
    get_date,
    YqlRunner,
)

TITLE = "[CPMADV-45] Running Campaigns | YQL"
AUX_TITLE = "[CPMADV-45] Running Campaigns Max Date | YQL"


def process_date(date, args):
    proxy = os.environ["YT_PROXY"]
    mon1 = date.replace(day=1)
    yc = YqlClient(db=proxy.lower(), token=os.environ["YQL_TOKEN"])
    yr = YqlRunner(client=yc, title=TITLE)
    with open("cpmadv_45_running_campaigns_stub.sql", "rb") as f:
        query = f.read().decode("utf8")
    query = apply_replacements(query, {"@[pool]": args["pool"], "@[date]": str(date), "@[mon1]": str(mon1)})
    yr.run(query, wait=True)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--pool", default="robot-mma-nirvana")
    parser.add_argument("--title", default=TITLE)
    parser.add_argument("--from")
    parser.add_argument("--redo", action="store_true")
    parser.add_argument("--to")
    args = vars(parser.parse_args())

    from_ = args.get("from")
    to_ = args.get("to")

    cluster = get_cluster(clusters, args)
    yt = get_driver(cluster).client

    if from_ and to_:
        dates = date_range(from_, to_)
    else:
        last_date_targeting = max(
            get_date(x) for x in yt.list("//home/videoquality/vh_analytics/targeting") if get_date(x)
        )
        print("targeting last date: {}".format(last_date_targeting))
        last_date_phrases = max(
            get_date(x) for x in yt.list("//home/videoquality/vh_analytics/phrases_stat") if get_date(x)
        )
        print("phrases last date: {}".format(last_date_phrases))
        last_date_campaigns = max(
            get_date(x) for x in yt.list("//home/videoquality/vh_analytics/underimpressions_tmp") if get_date(x)
        )
        print("campaigns last date: {}".format(last_date_campaigns))
        last_date_cpv = max(
            get_date(x) for x in yt.list("//home/videoquality/vh_analytics/campaigns_cpv") if get_date(x)
        )
        print("cpv last date: {}".format(last_date_cpv))
        last_available_date = min(last_date_targeting, last_date_phrases, last_date_campaigns, last_date_cpv)
        last_date = get_dates_from_stat(get_stat_headers(), "Video/Others/CPMADV-45-running-campaigns")[-1]
        if last_available_date > last_date:
            dates = sorted(
                date_range(last_date + datetime.timedelta(days=1), last_available_date), reverse=True
            )
        else:
            dates = []

    if dates:
        print("dates to process: {}".format(dates))
        for date in dates:
            print("processing {}".format(date))
            process_date(date, args)
    else:
        print("no dates to process")


if __name__ == "__main__":
    main()
