use hahn;
pragma yt.Pool = "@[pool]";
pragma AnsiInForEmptyOrNullableItemsCollections;

$date = "@[date]";

$campaign_stat_table = "//home/videoquality/vh_analytics/underimpressions_tmp/" || $date;
$phrase_stat_table = "//home/videoquality/vh_analytics/phrases_stat/" || $date;
$targeting_table = "//home/videoquality/vh_analytics/targeting/" || $date;
$campaigns_targeting_table = "//home/videoquality/vh_analytics/targeting_campaigns/" || $date;

$w = ($x) -> (IF($x == "", null, $x) ?? "empty");

$getTree = ($row)->([
    [$w($row.media_type)],
    [$w($row.media_type), $w($row.campaign_type)],
    [$w($row.media_type), $w($row.campaign_type), $w($row.client_name)],
    [$w($row.media_type), $w($row.campaign_type), $w($row.client_name), $w($row.campaign_id)],
]);

$cids = select distinct cid from $campaigns_targeting_table where ListLength(bs_categories_names) > 0;

$treelike = (
    select
        $getTree(TableRow()) as identificator,
        t.*
    from $campaign_stat_table as t
    where dsp_type = "direct" and cast(campaign_id as Int64) in $cids
);

$campaigns_stat_grouped = (
    select
        $date as fielddate,
        unwrap(ListNotNull(identificator)) as identificator,
        IF(ListLength(identificator) == 4, SOME(start_date)) as start_date,
        IF(ListLength(identificator) == 4, SOME(end_date)) as end_date,
        sum(amount_accepted) as amount_accepted,
        sum(amount_expected) as amount_expected,
        sum(amount_realised) as amount_realised,
        sum(shows) as shows,
        sum(underimpression) as underimpression,
        sum(underimpression_nz) as underimpression_nz,
        sum(underimpression_current) as underimpression_current,
        sum(underimpression_current_nz) as underimpression_current_nz,
    from $treelike
    flatten list by identificator
    group by identificator
);

$for_phrase_join = (
    select
        ListLast(identificator) as tree_part,
        cast(campaign_id as Int64) as cid
    from $treelike
);

$lw = ($l) -> ($l ?? ListCreate(String));

$getTargeting = ($age, $gender, $income, $interests, $use_auditory, $use_metrika) -> {
    $age = IF(ListLength($age) == 6, ListCreate(String), $age);
    $gender = IF(ListLength($gender) == 2, ListCreate(String), $gender);
    $income = IF(ListLength($income) == 5, ListCreate(String), $income);
    $use_auditory = IF($use_auditory > 0, ["custom_auditory"], ListCreate(String));
    $use_metrika = IF($use_metrika > 0, ["custom_metrika"], ListCreate(String));
    return String::JoinFromList(ListExtend(
        $lw($age), $lw($gender), $lw($income), $lw($interests), $lw($use_auditory), $lw($use_metrika)
    ), ",") ?? "-"
};

$interests = (
    select
        $getTargeting(age, gender, income, interests, use_auditory, use_metrika) as targeting,
        content_category_names,
        pid
    from $targeting_table
);

$transformGeo = ($x) -> {
    $sp = String::SplitToList($x, ",");
    $to_names = ListNotNull(ListMap($sp, ($x)->(IF($x like "-%", "-", "") || (Geo::RegionById(ABS(CAST($x as Int32))).name))));
    return String::JoinFromList($to_names, ",")
};

$assembleTargeting = ($targeting, $geo, $bsc, $ccn, $pi) -> {
    $result = (String::JoinFromList($bsc ?? ListCreate(String), ",") ?? "")
    || (String::JoinFromList($ccn ?? ListCreate(String), ",") ?? "")
    || (String::JoinFromList(ListMap($pi, ($x)->(cast($x as String))) ?? ListCreate(String), ",") ?? "")
    || ($targeting ?? "") || ((";geo=" || $transformGeo($geo)) ?? "") ;
    return IF($result is null or $result == "", "-", $result)
};

$campaigns_targeting = (
    select
        cid,
        bs_categories_names,
        allowed_page_ids
    from $campaigns_targeting_table
);

$phrases_stat = (
    select
        $date as fielddate,
        p.cid as cid,
        unwrap(ListExtend(tree_part, [cast(GroupExportID as String)])) as identificator,
        group_name,
        Shows as shows,
        (Cost / 1000000.0 / 1.18 * 30.0) as amount_realised,
        targeting as targeting__,
            geo,
            bs_categories_names,
            content_category_names,
            allowed_page_ids,
        $assembleTargeting(
            targeting,
            geo,
            bs_categories_names,
            content_category_names,
            allowed_page_ids,
        ) as targeting
    from $phrase_stat_table as p
    inner join any $for_phrase_join as c on (p.cid = c.cid)
    left join any $interests as i on (p.GroupExportID = i.pid)
    left join any $campaigns_targeting as ct on (p.cid = ct.cid)
);


$to_push = (
    select * from $campaigns_stat_grouped
    union all
    select * from $phrases_stat
);

upsert into stat.`Video/Others/CPMADV-77-underimpressions-bs/daily` ERASE BY (fielddate)
select ListNotNull(identificator) as identificator, s.* without identificator from $to_push as s
