use hahn;
pragma yt.Pool = "@[pool]";
pragma library("stability_common.sql");
import stability_common symbols $mskDateFromTs;

$date = "@[date]";
$mon1 = "@[mon1]";
$campaign_stat_table = "//home/videoquality/vh_analytics/underimpressions_tmp/" || $date;
$output_table = "//home/videoquality/vh_analytics/phrases_stat/" || $date;


$group = (
    select
        $date as `fielddate`,
        some(PhraseID) as PhraseID,
        GroupExportID,
        some(ExportID) as ExportID,
        some(PhraseExportID) as PhraseExportID,
        some(CurrencyID) as CurrencyID,
        sum(Cost) as Cost,
        sum(CostCur) as CostCur,
        sum(CostTaxFree) as CostTaxFree,
        sum(ClickRealCostCur) as ClickRealCostCur,
        sum(Shows) as Shows,
    from `//home/yabs/stat/DirectPhraseStatV2`
    where $mskDateFromTs(UpdateTime) >= $mon1 and $mskDateFromTs(UpdateTime) <= $date and GroupExportID > 0
    group by GroupExportID
);

$phrases_whitelist = (
    select
        cid, pid, adgroup_type, geo, group_name
    from `//home/direct/db/phrases` as p
    left semi join $campaign_stat_table as c on (p.cid = cast(c.campaign_id as Int64))
);

$filtered_group = (
    select g.*, cid, adgroup_type, geo, group_name
    from $group as g
    inner join any $phrases_whitelist as p on (g.GroupExportID = p.pid)
);

insert into $output_table WITH TRUNCATE 
select * from $filtered_group;
