use hahn;
pragma yt.Pool = "@[pool]";
pragma AnsiInForEmptyOrNullableItemsCollections;

$date = "@[date]";
$mon1 = "@[mon1]";
$campaign_stat_table = "//home/videoquality/vh_analytics/underimpressions_tmp/" || $date;
$output_table = "//home/videoquality/vh_analytics/underimpressions/" || $date;
$phrase_stat_table = "//home/videoquality/vh_analytics/phrases_stat/" || $date;
$targeting_table = "//home/videoquality/vh_analytics/targeting/" || $date;
$campaigns_targeting_table = "//home/videoquality/vh_analytics/targeting_campaigns/" || $date;

$w = ($x) -> (IF($x == "", null, $x) ?? "empty");

$lstMultiple = ($lst) -> {
    $lst = ListNotNull($lst);
    $len = ListLength($lst);
    return ListMap(
        ListFromRange(1, $len + 1),
        ($n)->(ListNotNull(ListTake($lst, $n)))
    )
};

$getIdentificatorStruct = ($row) -> (<|
    media_type: $row.media_type,
    campaign_type: $row.campaign_type,
    business_unit: $row.business_unit,
    client_name: $row.client_name,
    campaign_id: $row.campaign_id,
    group_id: null
|>);

$getTree = ($row)->{
    $result = [$w($row.media_type), $w($row.campaign_type), $row.business_unit, $w($row.client_name), $w($row.campaign_id)];
    return $lstMultiple($result)
};

$manager_logins = (
    select client_id, curr_counterparty_name, curr_counterparty_account_manager.login as manager_login
    from `//home/comdep-analytics/public/client_tiers/fact/latest`
    where curr_counterparty_account_manager.login is not null
);

$addManagerLogin = ($cn, $ml) -> (IF(
    $ml is not null,
    ($cn ?? "") || " (" || $ml || ")",
    $cn
));

$transform_client_name = (
    select
        $addManagerLogin(client_name, manager_login) as client_name,
        b.name as business_unit,
        c.* without c.client_name
    from $campaign_stat_table as c
    left join any `home/direct/db/campaigns` as camp on (cast(c.campaign_id as Int64) = camp.cid)
    left join any  `//home/direct/mysql-sync/current/ppcdict/straight/products` AS pr on camp.ProductID = pr.ProductID
    left join any `//home/direct/mysql-sync/current/ppcdict/straight/business_units_info` AS b ON b.id = pr.business_unit
    left join any $manager_logins as m on (camp.ClientID = m.client_id)
);

$treelike = (
    select
        $getIdentificatorStruct(TableRow()) as identificator_struct,
        $getTree($getIdentificatorStruct(TableRow())) as identificator,
        t.*
    from $transform_client_name as t
    where dsp_type = "direct"
);

$campaigns_stat_grouped = (
    select
        $date as fielddate,
        unwrap(ListNotNull(identificator)) as identificator,
        some(identificator_struct) as identificator_struct,
        IF(ListLength(identificator) == 4, SOME(start_date)) as start_date,
        IF(ListLength(identificator) == 4, SOME(end_date)) as end_date,
        sum(amount_accepted) as amount_accepted,
        sum(amount_expected) as amount_expected,
        sum(amount_realised) as amount_realised,
        sum(shows) as shows,
        sum(underimpression) as underimpression,
        sum(underimpression_nz) as underimpression_nz,
        sum(underimpression_current) as underimpression_current,
        sum(underimpression_current_nz) as underimpression_current_nz,
    from $treelike
    flatten list by identificator
    group by identificator
);

$for_phrase_join = (
    select
        ListLast(identificator) as tree_part,
        identificator_struct,
        cast(campaign_id as Int64) as cid
    from $treelike
);

$lw = ($l) -> ($l ?? ListCreate(String));

$getTargeting = ($age, $gender, $income, $interests, $use_auditory, $use_metrika) -> {
    $age = IF(ListLength($age) == 6, ListCreate(String), $age);
    $gender = IF(ListLength($gender) == 2, ListCreate(String), $gender);
    $income = IF(ListLength($income) == 5, ListCreate(String), $income);
    $use_auditory = IF($use_auditory > 0, ["custom_auditory"], ListCreate(String));
    $use_metrika = IF($use_metrika > 0, ["custom_metrika"], ListCreate(String));
    return String::JoinFromList(ListExtend(
        $lw($age), $lw($gender), $lw($income), $lw($interests), $lw($use_auditory), $lw($use_metrika)
    ), ",") ?? "-"
};

$interests = (
    select
        $getTargeting(age, gender, income, interests, use_auditory, use_metrika) as targeting,
        content_category_names,
        pid
    from $targeting_table
);

$transformGeo = ($x) -> {
    $sp = String::SplitToList($x, ",");
    $to_names = ListNotNull(ListMap($sp, ($x)->(IF($x like "-%", "-", "") || (Geo::RegionById(ABS(CAST($x as Int32))).name))));
    return String::JoinFromList($to_names, ",")
};

$assembleTargeting = ($targeting, $geo, $bsc, $ccn, $pi) -> {
    $result = (String::JoinFromList($bsc ?? ListCreate(String), ",") ?? "")
    || (String::JoinFromList($ccn ?? ListCreate(String), ",") ?? "")
    || (String::JoinFromList(ListMap($pi, ($x)->(cast($x as String))) ?? ListCreate(String), ",") ?? "")
    || ($targeting ?? "") || ((";geo=" || $transformGeo($geo)) ?? "") ;
    return IF($result is null or $result == "", "-", $result)
};

$campaigns_targeting = (
    select
        cid,
        bs_categories_names,
        allowed_page_ids
    from $campaigns_targeting_table
);

$phrases_stat = (
    select
        $date as fielddate,
        unwrap(ListExtend(tree_part, [cast(GroupExportID as String)])) as identificator,
        AddMember(RemoveMember(
            identificator_struct, "group_id"
        ), "group_id", GroupExportID) as identificator_struct,
        group_name,
        Shows as shows,
        (Cost / 1000000.0 / 1.18 * 30.0) as amount_realised,
        targeting as targeting__,
            geo,
            bs_categories_names,
            content_category_names,
            allowed_page_ids,
        $assembleTargeting(
            targeting,
            geo,
            bs_categories_names,
            content_category_names,
            allowed_page_ids,
        ) as targeting
    from $phrase_stat_table as p
    inner join any $for_phrase_join as c on (p.cid = c.cid)
    left join any $interests as i on (p.GroupExportID = i.pid)
    left join any $campaigns_targeting as ct on (p.cid = ct.cid)
);

$to_push_ = (
    select * from $campaigns_stat_grouped
    union all
    select * from $phrases_stat
);

$to_push = (
    select
        ListNotNull(identificator) as identificator, Yson::Serialize(Yson::From(identificator_struct)) as identificator_struct, s.* without identificator, identificator_struct
    from $to_push_ as s
);

insert into $output_table with TRUNCATE
select * from $to_push;

upsert into stat.`Video/Others/CPMADV-9-underimpressions/daily` ERASE BY (fielddate)
select * from $to_push;
