use hahn;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma yt.Pool = "@[pool]";
pragma library("stability_common.sql");
import stability_common symbols $parseDate, $formatDate;

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$output_table = "@[output_table]";

$toMonday = ($date) -> {
    $date = $parseDate($date);
    return $formatDate($date - DateTime::IntervalFromDays(DateTime::GetDayOfWeek($date) - 1))
};

$ppc_tmp = (
    SELECT TableName() as fielddate,
        ListMap(Yson::ConvertToList(cluid), Yson::ConvertToInt64) as cluid,
        ListMap(Yson::ConvertToList(cid), Yson::ConvertToInt64) as cid
    FROM RANGE('home/direct/logs/ppclog_api', $date_from, $date_to)
    WHERE application_id = "f71b01fc1d3747b9a10628a8671383f1"
    and http_status = 0
    and ListLength(Yson::ConvertToList(cid)) > 0
    and cmd in ("changes.check", "bids.get")
);

$cluid_to_login = (
    select
        cluid, some(login) as login
    from LIKE("//home/direct/mysql-sync/current", "ppc:%", "straight/users")
    group by uid as cluid
);

$ppc_tmp_flattened = select * from $ppc_tmp flatten list by cid;

$cids_ = select fielddate, cid, some(cluid)[0] as cluid from $ppc_tmp_flattened group by $toMonday(fielddate) as fielddate, cid;

$add_orderids = (
    select c.*, cl.login as login, camp.OrderID as OrderID
    from $cids_ as c
    left join any $cluid_to_login as cl on (c.cluid == cl.cluid)
    left join any `home/direct/db/campaigns` as camp on (c.cid == camp.cid)
);

$chevent_ = (
    select s.*, TableName() as fielddate
    from range(
        `cooked_logs/bs-chevent-cooked-log/1d`, $date_from, $date_to
    ) as s
    where fraudbits = 0 and eventflags = 0
);

$shows_filtered = (
    select s.*, cluid, login
    from $chevent_ as s
    inner join any $add_orderids as c on ($toMonday(s.fielddate) == c.fielddate and s.orderid == c.OrderID)
);

$shows_joined = (
    select s.*, domain
    from $shows_filtered as s
    left join any `//home/direct/db/banners` as b on (s.bannerid == b.BannerID)
);

$totalize = ($row) -> {
    $result = [$row];
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "login"), "login", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "producttype"), "producttype", "_total_")));
    $result = ListUnionAll($result, $add);
    return $result
};

$totalized = process $shows_joined using $totalize(TableRow());
$nwrap = ($x)->(IF($x == "", null, $x));

$shows_grouped = (
    select
        fielddate,
        login,
        producttype,
        CountDistinctEstimate(cluid) as logins,
        CountDistinctEstimate(orderid) as campaigns,
        CountDistinctEstimate(domain) as domains,
        count_if(countertype = 1) as shows,
        count_if(countertype = 2) as clicks,
        30.0 * sum(eventcost) / 1000.0 / 1000.0 / 1.18 as price,
        30.0 * sum_if(eventcost, countertype = 1) / 1000.0 / 1000.0 / 1.18 as price_shows,
        30.0 * sum_if(eventcost, countertype = 2) / 1000.0 / 1000.0 / 1.18 as price_clicks,
    from $totalized
    group by $toMonday(fielddate) as fielddate, $nwrap(login) ?? "-" as login, producttype
);

insert into $output_table WITH TRUNCATE 
select * from $shows_grouped;
