use hahn;
pragma yt.Pool = "@[pool]";
pragma AnsiInForEmptyOrNullableItemsCollections;
PRAGMA File('bigb.so', 'https://proxy.sandbox.yandex-team.ru/last/BIGB_UDF?attrs={"released":"stable"}&cache=1235435');
PRAGMA udf('bigb.so');

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$output_table = "@[output_table]";

$pageimps_table = "//home/bs/users/yabs-analytics/video/pageimp_ids_video_with_inapp";

$getCheventMediaType = ($producttype) -> (
    case
    when $producttype like "%reach%" and $producttype like "%media%" then "media"
    when $producttype like "%reach%" and $producttype like "%video%" then "video"
    else null
    end
);

$caesar = '//home/bs/logs/AdsCaesarOrdersFullDump/latest';

$direct_noncommerce = (
    select distinct OrderID
    from $caesar where Bigb::ParseOrderProfile(TableRow()).Resources.DirectBannersLogFields.OrderType not in (1, 8)
);

$chevent_ = (
    select
        TableName() as fielddate,
        pageid,
        impid,
        devicetype,
        producttype,
        countertype,
        clientid,
        orderid,
        revenue_by_eventtime as revenue
    from range(
        `//statbox/cube/daily/product_money/v1`, $date_from, $date_to
    )
    where fraudbits = 0 and $getCheventMediaType(producttype) is not null
);

$chevent = (
    select
        fielddate,
        producttype as product_type,
        $getCheventMediaType(producttype) as media_type,
        IF(countertype =1, 1, 0) as shows,
        IF(devicetype < 5, "touch", "desktop") as device_type,
        clientid as client_nmb,
        orderid as campaign_nmb,
        revenue,
        case
        when p.category != "other" then p.category
        else page.Name
        end as category,
        IF(
            orderid in $direct_noncommerce,
            "non-commerce",
            "commerce"
        ) as commerce_type,
        ListNotNull([
            "_total_",
            IF(p.video_type != "other" and $getCheventMediaType(producttype) == "video", p.video_type),
            case
            when $getCheventMediaType(producttype) != "video" then null
            when p.video_placement_name == "instream" then "instream"
            else "outstream"
            end,
        ]) as impression_type
    from $chevent_ as c
    left join any $pageimps_table as p on (c.pageid == p.pageid and c.impid == p.impid)
    left join any `home/yabs/dict/Page` as page on (c.pageid == page.PageID)
);

select * from $chevent limit 20;

$tmp_unified = (
    select * from $chevent
);


$totalize = ($row) -> {
    $result = [$row];
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "commerce_type"), "commerce_type", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListFlatMap(
        $result,
        ($x)->([
            AddMember(RemoveMember($x, "category"), "category", "_total_"),
            AddMember(RemoveMember($x, "category"), "category", IF($x.category like "%VH%", "_vh_", "_other_"))
        ])
    );
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "device_type"), "device_type", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "media_type"), "media_type", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "product_type"), "product_type", "_total_")));
    $result = ListUnionAll($result, $add);
    return $result
};

$totalized = process $tmp_unified using $totalize(TableRow());

$flattened = select * from $totalized flatten list by impression_type;

$w = ($x) -> (IF($x = "", null, $x));

$grouped = (
    select
        fielddate,
        commerce_type,
        category,
        device_type,
        media_type,
        product_type,
        impression_type,
        sum(shows) as shows,
        sum(revenue) as revenue,
        CountDistinctEstimate(client_nmb) as clients,
        CountDistinctEstimate(campaign_nmb) as campaigns,
    from $flattened
    group by
        $w(fielddate) ?? "-" as fielddate,
        $w(commerce_type) ?? "-" as commerce_type,
        $w(category) ?? "-" as category,
        $w(device_type) ?? "-" as device_type,
        $w(media_type) ?? "-" as media_type,
        $w(product_type) ?? "-" as product_type,
        $w(impression_type) ?? "-" as impression_type

);

$to_upsert = (
    select * from $grouped
    where shows >= 10000
);

upsert into stat.`Video/Others/Strm/MMA-5192-cpm-dash-dwh/daily` erase by (fielddate)
select * from $to_upsert;
