use hahn;
pragma yt.Pool = "@[pool]";
pragma library("mma_5201_subqueries.sql");
import mma_5201_subqueries symbols $aggregate_awaps, $aggregate_direct;

$date = "@[date]";
$output_table = "@[output_table]";
$tmp_direct_table = "//home/videoquality/vh_analytics/underimpressions_tmp/" || $date;
$tmp_awaps_table = "//home/videoquality/vh_analytics/underimpressions_tmp_awaps/" || $date;

$tmp = (
    select * from $tmp_direct_table as c
    union all
    select * from $tmp_awaps_table as c
);

$totalize = ($row) -> {
    $result = [$row];
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "client_name"), "client_name", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "dsp_type"), "dsp_type", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "media_type"), "media_type", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "campaign_id"), "campaign_id", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "campaign_type"), "campaign_type", "_total_")));
    $result = ListUnionAll($result, $add);
    return $result
};


$totalized = process $tmp using $totalize(TableRow());
$nwrap = ($x)->(IF(String::Strip($x) == "", null, $x));

$grouped = (
    select
        $date as fielddate,
        dsp_type,
        client_name,
        campaign_id,
        campaign_type,
        media_type,
        sum(amount_accepted) as amount_accepted,
        sum(amount_expected) as amount_expected,
        sum(amount_realised) as amount_realised,
        sum(shows) as shows,
        sum(underimpression) as underimpression,
        sum(underimpression_nz) as underimpression_nz,
        sum(underimpression_current) as underimpression_current,
        sum(underimpression_current_nz) as underimpression_current_nz,
    from $totalized
    group by $nwrap(dsp_type) ?? "-" as dsp_type,
        $nwrap(client_name) ?? "-" as client_name,
        $nwrap(campaign_id) ?? "-" as campaign_id,
        $nwrap(campaign_type) ?? "-" as campaign_type,
        $nwrap(media_type) ?? "-" as media_type
);

insert into $output_table with truncate
select * from $grouped;
