use hahn;
pragma AnsiInForEmptyOrNullableItemsCollections;

$formatDate = DateTime::Format("%Y-%m-%d");
$getMskDate = ($dt, $sub) -> {
    $dt = cast($dt as DateTime) - DateTime::IntervalFromMinutes($sub);
    $tm = DateTime::Split($dt);
    $tm = DateTime::MakeTimestamp(DateTime::Update($tm, "Europe/Moscow" as Timezone));
    return $formatDate($tm)
};
$daysDiff = ($date1, $date2) -> (DateTime::ToDays($date2 - $date1) + 1);

$awaps_pg_to_media_type = ($p) -> {
RETURN CASE
           WHEN $p == 'Видеореклама' THEN 'video'
           WHEN $p == 'Аудиореклама' THEN 'audio'
           ELSE 'media'
       END;
};

$adgroupToMediaType = ($adgroup) -> (case
when $adgroup = "cpm_video" then "video"
when $adgroup = "cpm_yndx_frontpage" then "media_frontpage"
when $adgroup like "%cpm%" then "media"
else null
end);

$calcExpected = ($aa, $curr_date, $start_time, $end_time) -> {
    $curr_date = CAST($curr_date as Date);
    $start_time = CAST($start_time as Date);
    $end_time = CAST($end_time as Date);
    return case
    when $curr_date < $start_time then 0
    when $curr_date >= $end_time then $aa
    else $aa * (
        $daysDiff($start_time, $curr_date) /
        CAST($daysDiff($start_time, $end_time) as Double)
    )
    end
};  


define subquery $base_awaps($curr_date, $mon1, $nextmon1) as
$mon1time = $mon1 || "T03:00:00Z";
$nextmon1time = $nextmon1 || "T03:00:00Z";

select
    line_nmb,
    client_nmb,
    campaign_type,
    some(campaign.campaign_name) as campaign_name,
    media_type,
    schedule_nmb,
    IF(
        some(curr_counterparty_name) like "%client_id%",
        some(client_name),
        some(curr_counterparty_name)
    ) ?? some(campaign.advertiser_name) as client_name,
    some(flight.campaign_nmb) as campaign_nmb,
    amount_accepted,
    start_date,
    end_date,
    $calcExpected(
        amount_accepted, $curr_date, start_date, end_date
    ) as amount_expected,
    currency_iso_code,
    sum(stats.ado_revenue_realised) as ado_revenue_realised,
    sum(stats.ado_block_shows) as ado_block_shows,
from
    (select
        report_date,
        schedule_nmb,
        sum(ado_block_shows) as ado_block_shows,
        sum(ado_revenue_realized) as ado_revenue_realised
    from `//home/comdep-analytics/YAN/cubes/ado/latest/all`
    group by report_date, schedule_nmb) AS stats
    inner join any `//home/comdep-analytics/YAN/cubes/ado/dicts/schedule_info` as info
    on stats.schedule_nmb = info.schedule_nmb
    inner join any (
        select
            schedule_nmb,
            amount as amount_accepted
        from `home/awaps/db/adoffice/ado_current/t_buying` 
    ) as tb on stats.schedule_nmb == tb.schedule_nmb
    left join any `//home/awaps/cooked/flight` as flight
    on stats.schedule_nmb == flight.schedule_nmb
    left join any `//home/awaps/cooked/campaign` as campaign
    on flight.campaign_nmb == campaign.campaign_nmb
    left join
    (select client_id, curr_counterparty_name from `//home/comdep-analytics/public/client_tiers/fact/latest_v2`) as countr
    on info.client_nmb = countr.client_id
where
    ((info.schedule_start_time < $nextmon1time and info.schedule_start_time >= $mon1time) or
    (info.schedule_end_time > $mon1time and info.schedule_end_time <= $nextmon1time)) and
    (stats.report_date >= $getMskDate(info.schedule_start_time, 0) and  stats.report_date <= $getMskDate(info.schedule_end_time, 1)) and
    stats.report_date <= $curr_date and
    -- info.line_is_stopped=false and
    -- info.line_status_nmb!=32 and
    $awaps_pg_to_media_type(info.product_group) in ("video", "media")
    -- info.line_currency_nmb == 643
group by
    stats.schedule_nmb as schedule_nmb,
    info.line_nmb as line_nmb,
    info.client_nmb as client_nmb,
    $awaps_pg_to_media_type(info.product_group) as media_type,
    IF(info.is_marketing, "non-commerce", "commerce") as campaign_type,
    tb.amount_accepted as amount_accepted,
    $getMskDate(info.schedule_start_time, 0) as start_date,
    $getMskDate(info.schedule_end_time, 1)   as end_date,
    info.line_currency_nmb as currency_iso_code;
end define;

define subquery $aggregate_awaps($base_query, $curr_date) as

$group1 = (
select
    client_nmb,
    client_name,
    line_nmb,
    schedule_nmb,
    campaign_nmb,
    campaign_type,
    campaign_name,
    start_date,
    end_date,
    media_type,
    ado_block_shows,
    amount_accepted,
    amount_expected,
    ado_revenue_realised
from
    $base_query() as base
);

$group2 = (
    select
        client_name,
        campaign_id,
        media_type,
        some(campaign_type) as campaign_type,
        sum(amount_accepted) as amount_accepted,
        min(start_date) as start_date,
        max(end_date) as end_date,
        IF(sum(amount_expected) < 0,0,sum(amount_expected)) as amount_expected,
        sum(ado_revenue_realised) as amount_realised,
        sum(ado_block_shows) as shows,
        (sum(amount_expected) ?? 0) - (sum(ado_revenue_realised) ?? 0) as underimpression,
        IF(
            max(end_date) >= $curr_date,
            (sum(amount_expected) ?? 0) - (sum(ado_revenue_realised) ?? 0),
            0
        ) as underimpression_current
    from $group1
    group by
        (client_name ?? "") as client_name,
        (cast(campaign_nmb as String) ?? "") as campaign_id,
        media_type
);


select g.*,
  max_of(underimpression, 0) as underimpression_nz,
  max_of(underimpression_current, 0) as underimpression_current_nz,
from $group2 as g;
end define;

define subquery $base_direct($curr_date, $mon1, $nextmon1) as
$format = DateTime::Format("%Y-%m-%d");
$begin_week_last = $format(DateTime::StartOfWeek(DateTime::FromSeconds(Cast(DateTime::ToSeconds(CAST($curr_date AS DATE)) - 7 * 24 * 60 * 60 as uint32))));
$end_week_last = $format(DateTime::StartOfWeek(CAST($curr_date AS DATE)));
$monlast = $format(CAST($nextmon1 as Date) - DateTime::IntervalFromDays(1));


$stat_ = (
  SELECT
    OrderID,
    stat_date,
    sum(Shows) as shows,
    sum((Cost / 1000000) * 30 / 1.18) as sum_rub
FROM `//home/yabs/stat/OrderStatDay`
where
    Shows > 0
group by
    OrderID,
    $format(AddTimezone(DateTime::FromSeconds(CAST(UpdateTime as Uint32)), "Europe/Moscow")) as stat_date
);

$stat = (select * from $stat_ where stat_date <= $curr_date);

$camp = (
  SELECT
    cid,
    fio,
    name,
    OrderID,
    ClientID,
    ProductID,
    case
        when strategy_name in ("autobudget_avg_cpv_custom_period", "period_fix_bid", "autobudget_max_impressions_custom_period",
                            "autobudget_max_reach_custom_period") then Yson::ConvertToString(Yson::Lookup(strategy_params, 'start'))
        when start_time = "0000-00-00" then $mon1
        else nvl(start_time, $mon1)
    end as start_date,
    case
        when strategy_name in ("autobudget_avg_cpv_custom_period", "period_fix_bid", "autobudget_max_impressions_custom_period",
                            "autobudget_max_reach_custom_period") then Yson::ConvertToString(Yson::Lookup(strategy_params, 'finish'))
        when finish_time = "0000-00-00" then $monlast
        else nvl(finish_time, $monlast)
    end as end_date,
    currency,
    autobudget,
    strategy_name,
    Cast(day_budget as double) as day_budget,
    cast(autobudget_sum_rub as double) as autobudget_sum_rub,
    case
        when strategy_name in ("autobudget_avg_cpv_custom_period", "period_fix_bid", "autobudget_max_impressions_custom_period",
                            "autobudget_max_reach_custom_period") then Yson::ConvertToDouble(Yson::Lookup(strategy_params, 'budget'))
        else 0
    end as budget,
FROM `//home/direct/db/campaigns`
WHERE
    type LIKE '%cpm%' AND
    OrderID > 0 AND
    currency == "RUB"
);

$caesar = '//home/bs/logs/AdsCaesarOrdersFullDump/latest';

$order_info = (
    select 
        OrderID,
        if(Bigb::ParseOrderProfile(TableRow()).Resources.DirectBannersLogFields.OrderType in (1, 8), 'commerce' , 'non-commerce') as order_type
    from 
        $caesar
);

$pre_grouping = (
  SELECT
    OrderID,
    cid,
    some(camp.fio) as client_name,
    some(camp.name) as campaign_name,
    some(i.order_type) as order_type,
    ClientID,
    ProductID,
    start_date,
    end_date,
    autobudget,
    strategy_name,
    autobudget_sum_rub,
    budget,
    day_budget,
    sum(case
        when stat_date >= $mon1 and stat_date < $nextmon1 then sum_rub
        else 0
    end) as ado_revenue_realised_oct,
    sum(case
        when strategy_name = "cpm_default" and stat_date >= $mon1 and stat_date < $nextmon1 then sum_rub
        when strategy_name in ("autobudget_avg_cpv_custom_period", "period_fix_bid", "autobudget_max_impressions_custom_period",
                                "autobudget_max_reach_custom_period") and
                                stat_date >= start_date and
                                stat_date <= end_date then sum_rub
        when strategy_name in ("autobudget_avg_cpv", "autobudget_max_impressions", "autobudget_max_reach") and
                                stat_date >= $begin_week_last and
                                stat_date < $end_week_last then sum_rub
        else 0
    end) as ado_revenue_realised,
    sum(case
        when strategy_name = "cpm_default" and stat_date >= $mon1 and stat_date < $nextmon1 then shows
        when strategy_name in ("autobudget_avg_cpv_custom_period", "period_fix_bid", "autobudget_max_impressions_custom_period",
                                "autobudget_max_reach_custom_period") and
                                stat_date >= start_date and
                                stat_date <= end_date then shows
        when strategy_name in ("autobudget_avg_cpv", "autobudget_max_impressions", "autobudget_max_reach") and
                                stat_date >= $begin_week_last and
                                stat_date < $end_week_last then shows
        else 0
    end) as shows,
    sum(case
        when strategy_name = "cpm_default" and stat_date >= $mon1 and stat_date < $nextmon1 then 1
        when strategy_name in ("autobudget_avg_cpv_custom_period", "period_fix_bid", "autobudget_max_impressions_custom_period",
                                "autobudget_max_reach_custom_period") and
                                stat_date >= start_date and
                                stat_date <= end_date then 1
        when strategy_name in ("autobudget_avg_cpv", "autobudget_max_impressions", "autobudget_max_reach") and
                                stat_date >= $begin_week_last and
                                stat_date < $end_week_last then 1
        else 0
    end) as active_days
FROM $stat AS stat
    inner join $camp as camp on (stat.OrderID = camp.OrderID)
    LEFT JOIN any $order_info AS i ON (i.OrderID = stat.OrderID)
where camp.start_date <= $monlast AND camp.end_date >= $mon1
group by
    stat.OrderID as OrderID,
    camp.cid as cid,
    camp.ClientID as ClientID,
    camp.ProductID as ProductID,
    camp.start_date as start_date,
    camp.end_date as end_date,
    camp.autobudget as autobudget,
    camp.strategy_name as strategy_name,
    camp.day_budget as day_budget,
    camp.budget as budget,
    camp.autobudget_sum_rub as autobudget_sum_rub
);

$grouping = (
SELECT
    OrderID,
    cid,
    client_name,
    campaign_name,
    order_type,
    ClientID,
    ProductID,
    start_date,
    end_date,
    autobudget,
    strategy_name,
    shows,
    ado_revenue_realised,
    active_days,
    day_budget,
    budget,
    autobudget_sum_rub,
    case
        when strategy_name = "cpm_default" then active_days * day_budget
        when strategy_name in ("autobudget_avg_cpv_custom_period", "period_fix_bid", "autobudget_max_impressions_custom_period",
                                "autobudget_max_reach_custom_period") then budget
        when strategy_name in ("autobudget_avg_cpv", "autobudget_max_impressions", "autobudget_max_reach") then autobudget_sum_rub
        else 0
    end as amount_accepted,
    case
        when strategy_name = "cpm_default" then active_days * day_budget
        when strategy_name in ("autobudget_avg_cpv_custom_period", "period_fix_bid", "autobudget_max_impressions_custom_period",
                                "autobudget_max_reach_custom_period") then budget * MIN_OF(CAST(DateTime::ToDays(CAST($curr_date AS DATE) -
        CAST(start_date AS DATE)) AS DOUBLE) / CAST(DateTime::ToDays(CAST(end_date AS DATE) -
        CAST(start_date AS DATE)) AS DOUBLE), 1)
        when strategy_name in ("autobudget_avg_cpv", "autobudget_max_impressions", "autobudget_max_reach") then autobudget_sum_rub
        else 0 end
    as amount_expected,
from $pre_grouping
where ado_revenue_realised_oct > 0 and ado_revenue_realised > 0
);

select
IF(amount_expected < 0, 0, amount_expected) as amount_expected,
Case 
    when adgroup_types like "," then "mixed"
    else adgroup_types
end as media_type,
g.* without g.amount_expected from $grouping as g
inner join any (
    SELECT cid, String::JoinFromList(ListSort(ListUniq(ListNotNull(ListMap(
        AGGREGATE_LIST_DISTINCT(adgroup_type), $adgroupToMediaType
    )))), ",") as adgroup_types
FROM `//home/direct/db/phrases`
GROUP BY cid
) as o on (g.cid == o.cid);
end define;

define subquery $aggregate_direct($base_query, $curr_date) as

$grouping1 = (
select
    base.ClientID as client_id,
    IF(
        curr_counterparty_name like "%client_id%",
        countr.client_name,
        curr_counterparty_name
    ) as client_name,
    base.OrderID as order_id,
    base.cid as cid,
    base.campaign_name as campaign_name,
    base.order_type as order_type,
    media_type,
    start_date,
    end_date,
    shows,
    ado_revenue_realised,
    amount_accepted,
    amount_expected,
from
    $base_query() as base
    left join any
    (select client_id, curr_counterparty_name, client_name from `//home/comdep-analytics/public/client_tiers/fact/latest_v2`) as countr
    on base.ClientID = countr.client_id
);

$grouping2 = (
  select
      client_name,
      media_type,
      campaign_id,
      some(order_type) as campaign_type,
      min(start_date) as start_date,
      max(end_date) as end_date,
      sum(amount_accepted) as amount_accepted,
      max_of(sum(amount_expected) ?? 0, 0) as amount_expected,
      sum(ado_revenue_realised) as amount_realised,
      sum(shows) as shows,
      (sum(amount_expected) ?? 0) - (sum(ado_revenue_realised) ?? 0) as underimpression,
      IF(
          max(end_date) >= $curr_date,
          (sum(amount_expected) ?? 0) - (sum(ado_revenue_realised) ?? 0),
          0
      ) as underimpression_current
  from $grouping1
  group by
      (client_name ?? "") as client_name,
      (cast(cid as String) ?? "") as campaign_id,
      media_type
);

select g.*,
  max_of(underimpression, 0) as underimpression_nz,
  max_of(underimpression_current, 0) as underimpression_current_nz,
from $grouping2 as g;
end define;

export $base_awaps, $base_direct, $aggregate_awaps, $aggregate_direct;
