use hahn;
pragma yt.Pool = "@[pool]";

$date = "@[date]";
$week_ago = "@[week_ago]";
$output_table = "@[output_table]";

$formatDate = DateTime::Format("%Y-%m-%d");
$getMskDate = ($ts) -> ($formatDate(AddTimezone(DateTime::FromSeconds(cast($ts as Uint32)), "Europe/Moscow")));

$getCat = ($ts)->(case
when $getMskDate($ts) == $date then "today"
when $getMskDate($ts) == $week_ago then "week ago"
else null
end);

$getHoursDiff = ($ts1, $ts2) -> (IF(
    $ts1 is not null and $ts2 is not null and $ts2 >= $ts1, Math::Round(($ts2 - $ts1) / 3600.0, -2)
));

$pageids = (
select String::JoinFromList(aggregate_list_distinct(pageid), ",")
from (
    select distinct cast(PageID as String) as pageid
    from `home/yabs/dict/Page`
    where Name = "news.yandex.ru"
    union all
    select distinct cast(pageid as String) as pageid
    from `//home/bs/users/yabs-analytics/video/pageimp_ids_video_with_inapp`
    where category like "%Новости%"
));

$check = ($l1, $l2) ->{
    $l1 = String::SplitToList($l1, ",") ?? ListCreate(String?);
    $l2 = String::SplitToList($l2, ",") ?? ListCreate(String?);
    return ListLength(DictKeys(SetIntersection(
        ToSet($l1), ToSet($l2)
    ))) > 0
};

$tmp_url = (
    select
        $date as fielddate,
        $getCat(min_timestamp) as day_cat,
        wonproducttypes,
        "urlmd5" as url_type,
        case
        when $getCat(min_timestamp) == "today" and $getHoursDiff(min_timestamp, min_timestamp_non_null_bs_tags) <= 1 then $getHoursDiff(min_timestamp, min_timestamp_non_null_bs_tags)
        when $getCat(min_timestamp) == "week ago" and $getHoursDiff(min_timestamp, min_timestamp_non_null_bs_tags) <= 7 then $getHoursDiff(min_timestamp, min_timestamp_non_null_bs_tags)
        else null
        end as hours_diff,
    from `//home/videoquality/vh_analytics/mma-5254/by_urlmd5`
    where $getCat(min_timestamp) is not null and $check(pageids, $pageids)
);

$tmp_ci = (
    select
        $date as fielddate,
        $getCat(min_timestamp) as day_cat,
        wonproducttypes,
        "contentid" as url_type,
        case
        when $getCat(min_timestamp) == "today" and $getHoursDiff(min_timestamp, min_timestamp_non_null_bs_tags) <= 1 then $getHoursDiff(min_timestamp, min_timestamp_non_null_bs_tags)
        when $getCat(min_timestamp) == "week ago" and $getHoursDiff(min_timestamp, min_timestamp_non_null_bs_tags) <= 7 then $getHoursDiff(min_timestamp, min_timestamp_non_null_bs_tags)
        else null
        end as hours_diff,
    from `//home/videoquality/vh_analytics/mma-5254/by_contentid`
    where $getCat(min_timestamp) is not null and $check(pageids, $pageids)
);

$tmp = (
    select * from $tmp_url
    union all
    select * from $tmp_ci
);

$grouped = (
    select
        fielddate,
        day_cat,
        url_type,
        wonproducttypes,
        count(*) as `count`,
        count_if(hours_diff is null) as without_bstags,
        percentile(hours_diff, 0.1) as hours_diff_p10,
        percentile(hours_diff, 0.2) as hours_diff_p20,
        percentile(hours_diff, 0.3) as hours_diff_p30,
        percentile(hours_diff, 0.4) as hours_diff_p40,
        percentile(hours_diff, 0.5) as hours_diff_p50,
        percentile(hours_diff, 0.6) as hours_diff_p60,
        percentile(hours_diff, 0.7) as hours_diff_p70,
        percentile(hours_diff, 0.8) as hours_diff_p80,
        percentile(hours_diff, 0.9) as hours_diff_p90,
    from $tmp
    group by fielddate,
        day_cat,
        url_type,
        wonproducttypes
);

insert into $output_table WITH TRUNCATE 
select * from $grouped;
