#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import datetime
import os
from yql.api.v1.client import YqlClient
from videolog_common import YqlRunner, apply_replacements

TITLE = "MMA-5254 | YQL"

stub = """
use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$parseBSTags = ($queryargs) -> {
    $parsed = Dsv::Parse($queryargs, "&");
    $tags = $parsed["931"];
    return if(
        DictContains($parsed, "931"),
        ListMap(String::SplitToList($tags, "%0A"), ($x)->(CAST($x as UInt32))),
        null
    )
};

$nwrap = ($x) -> (IF($x not in ("", "0"), $x, null));

$tmp = (
SELECT
    $nwrap(contentid ?? Dsv::Parse(queryargs, "&")["354"]) as contentid,
    case
    when $nwrap(contentid ?? Dsv::Parse(queryargs, "&")["354"]) is not null then null
    else cast($nwrap(urlmd5) as Uint64)
    end as urlmd5,
    cast(eventtime as Uint64) as `timestamp`,
    $parseBSTags(queryargs) as bs_tags
FROM range(`logs/bs-hit-log/1d`, `@[month_start]`, `@[month_end]`) with columns Struct<contentid:String?>
WHERE wonproducttype = 'video-creative-reach'
    AND cast(hitlogid as Uint64) > 1
    AND eventflags IN ("0","2","16384","16386") --дает хорошие хиты в РСЯ
    AND find(impressionoptions, "roll") is not null
);

$contentid = (
    select * from $tmp where contentid is not null
);

$urlmd5 = (
    select * from $tmp where urlmd5 is not null
);

$grouped_contentid = (
    select
        contentid,
        min(`timestamp`) as min_timestamp,
        min(if(bs_tags is not null, `timestamp`)) as min_timestamp_non_null_bs_tags,
        min(if(bs_tags is not null and ListLength(bs_tags) > 0, `timestamp`)) as min_timestamp_non_empty_bs_tags,
        some(if(bs_tags is not null and ListLength(bs_tags) > 0, bs_tags)) as bs_tags
    from $contentid
    group by contentid
);

$grouped_urlmd5 = (
    select
        urlmd5,
        min(`timestamp`) as min_timestamp,
        min(if(bs_tags is not null, `timestamp`)) as min_timestamp_non_null_bs_tags,
        min(if(bs_tags is not null and ListLength(bs_tags) > 0, `timestamp`)) as min_timestamp_non_empty_bs_tags,
        some(if(bs_tags is not null and ListLength(bs_tags) > 0, bs_tags)) as bs_tags
    from $urlmd5
    group by urlmd5
);

insert into `home/videoquality/vh_analytics/mma-5254/by_contentid_@[month]` WITH TRUNCATE
select * from $grouped_contentid;

insert into `home/videoquality/vh_analytics/mma-5254/by_urlmd5_@[month]` WITH TRUNCATE
select * from $grouped_urlmd5;
"""


def last_day_of_month(any_day):
    next_month = any_day.replace(day=28) + datetime.timedelta(days=4)
    return next_month - datetime.timedelta(days=next_month.day)


def main():
    yc = YqlClient(db="hahn", token=os.environ["YQL_TOKEN"])
    yr = YqlRunner(client=yc, title=TITLE)
    for month in list(range(1, 11))[::-1]:
        month_start = datetime.date(2020, month, 1)
        month_end = last_day_of_month(month_start)
        month_rep = datetime.datetime.strftime(month_start, "%Y-%m")
        query = apply_replacements(stub, [
            ("@[month]", month_rep),
            ("@[month_start]", str(month_start)),
            ("@[month_end]", str(month_end)),
        ])
        yr.run(query)


if __name__ == "__main__":
    main()
