use hahn;

$output_table = "home/videoquality/vh_analytics/MMA-5272-youtube-import/" || $date;

$stripPrefix = ($s, $prefix) -> (IF(
    $s like ($prefix || "%"),
    substring($s, unwrap(length($prefix))),
    $s
));

$getHost = ($url) -> {
    $host = Url::GetHost($url);
    $host = $stripPrefix($host, "m.");
    $host = $stripPrefix($host, "www.");
    return $host
};

$di_youtube = (
    select GroupingUrl, mediainfo.AuthorId as author_id
    from `//home/videoindex/full/docbase/prevdata/full_index/direct_index`
    where $getHost(GroupingUrl) = "youtube.com"
);

$ugc_importing = (
    select
        `importer.id` as channel_id,
        `importer.source_channel_id` as author_id
    from `//home/video-hosting/ugc_replica/ugc_importer`
    where `importer.status` = "importing"
);

$ugc_data = (
    select
        channel_id,
        author_id,
        `video_meta.id` as video_meta_id
    from `//home/video-hosting/ugc_replica/ugc_video_meta` as m
    inner join any $ugc_importing as i on (m.`video_meta.channel_id` = i.channel_id)
    where not m.`video_meta.deleted`
);

insert into `home/videoquality/vh_analytics/MMA-5272-youtube-import/ugc` WITH TRUNCATE 
select * from $ugc_data;

$old_base_channels = (
    select
        ContentGroupID as parent_id,
        ListReverse(String::SplitToList(Value, "/"))[0] as author_id
    from `//home/video-hosting/base/ContentResource`
    where ResourceName = "content_source_url" and Value like "%youtube.com/channel%"
);

$old_base_videos = (
    select
        author_id,
        ContentGroupID
    from `//home/video-hosting/base/ContentGroup` as c
    inner join any $old_base_channels as ch on (c.ParentID = ch.parent_id)
    where not c.OptionsDeleted
);

insert into `home/videoquality/vh_analytics/MMA-5272-youtube-import/old` WITH TRUNCATE 
select * from $old_base_videos;



$old_base_grouped = (
    select
        "old_base" as base_type,
        author_id,
        COUNT(DISTINCT ContentGroupID) as imported_ids
    from $old_base_videos
    group by author_id
);

$ugc_data_grouped = (
    select
        "ugc" as base_type,
        author_id,
        COUNT(DISTINCT video_meta_id) as imported_ids
    from $ugc_data
    group by author_id
);

$di_grouped = (
    select
        author_id,
        COUNT(DISTINCT GroupingUrl) as direct_index_urls
    from $di_youtube
    group by author_id
);

$old_base_joined = (
    select o.*, direct_index_urls
    from $old_base_grouped as o
    left join any $di_grouped as d using (author_id)
);

$ugc_data_joined = (
    select u.*, direct_index_urls
    from $ugc_data_grouped as u
    left join any $di_grouped as d using (author_id)
);

$merged = (
    select * from $ugc_data_joined
    union all
    select * from $old_base_joined
);

$totalize = ($row) -> {
    $result = [$row];
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "author_id"), "author_id", "_total_")));
    $result = ListUnionAll($result, $add);
    return $result
};

$grouped = (
    select
        author_id,
        base_type,
        sum(imported_ids) as imported_ids,
        sum(direct_index_urls) as direct_index_urls
    from (
        process $merged using $totalize(TableRow())
    )
    group by author_id, base_type
);

$for_report = (
    select $date as fielddate,
    unwrap(author_id) as author_id,
    s.* without s.author_id
    from $grouped as s
);

upsert into stat.`Video/Others/MMA-5272-youtube-import/daily`
select * from $for_report;

insert into $output_table WITH TRUNCATE 
select * from $merged;
