#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import os
import argparse
from nile.api.v1 import (
    clusters,
    filters as nf,
    extractors as ne,
    aggregators as na,
    Record
)
import json


job_root = '//home/videolog/mma_1674'
job_root_pub = '//home/videolog/mma_1674/pub'


def get_key(x):
    if 'ji' in x:
        return x['ji']['query']
    elif 'inputValues' in x:
        return x['inputValues']['query']


def get_value(x):
    if 'result' in x:
        return x['result']['result']
    elif 'outputValues' in x:
        return x['outputValues']['result']


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--date')
    parser.add_argument('--input_wo_players')
    parser.add_argument('--input_with_players')
    args = parser.parse_args()

    date = args.date

    wo_players_table = '{}/{}/wo_players'.format(job_root, date)
    with_players_1_table = '{}/{}/with_players_1'.format(job_root, date)
    with_players_2_table = '{}/{}/with_players_2'.format(job_root, date)

    input_wo_players = json.load(open(args.input_wo_players))
    input_with_players = json.load(open(args.input_with_players))

    result_dct = {
        get_key(x): get_value(x) for x in input_wo_players
    }
    result_dct.update({
        get_key(x): get_value(x) for x in input_with_players
    })

    hahn = clusters.yt.Hahn(token=os.environ['YT_TOKEN'])

    for table in (
        wo_players_table,
        with_players_1_table,
        with_players_2_table
    ):
        result_table_1 = '{}/{}_result'.format(
            job_root_pub, table.split('/')[-1]
        )
        result_table_2 = '{}/{}/{}_result'.format(
            job_root, date, table.split('/')[-1]
        )
        recs = list(hahn.read(table))
        for result_table in [result_table_1, result_table_2]:
            hahn.write(
                path=result_table,
                records=[
                    Record(rec, result=result_dct.get(
                        rec['ContentGroup.Name'].decode('utf8'), u'N/A'
                    ))
                    for rec in recs
                ]
            )


if __name__ == "__main__":
    main()
