USE hahn;
/*
    Без сериалов
*/

INSERT INTO [{path}] WITH TRUNCATE


SELECT 
    OntoIdResource.Value,
    ContentGroup.Name,
    ContentType.Name,
    'https://frontend.vh.yandex.ru/player/' || ContentGroup.UUID || '?from=test'
FROM 
    [//home/video-hosting/base/ContentResource] as OntoIdResource
JOIN
    [//home/video-hosting/base/ContentGroup] as ContentGroup
ON 
    ContentGroup.ContentGroupID = OntoIdResource.ContentGroupID
JOIN
    [//home/video-hosting/base/ContentType] as ContentType
ON 
    ContentGroup.ContentTypeID = ContentType.ContentTypeID
JOIN
    [//home/video-hosting/base/ContentResource] as ThumbnailResource
ON 
    ContentGroup.ContentGroupID = ThumbnailResource.ContentGroupID
JOIN
    [//home/video-hosting/base/ContentResource] as OntoPosterInfoResource
ON 
    ContentGroup.ContentGroupID = OntoPosterInfoResource.ContentGroupID
WHERE 
    OntoIdResource.ResourceName = 'onto_id'
    /* Only if onto_id exisis */
        AND OntoIdResource.Value IS NOT NULL
        AND OntoIdResource.Value != ''
    /* Only if thumbnail exisis */
        AND ThumbnailResource.ResourceName = 'thumbnail'
        AND ThumbnailResource.Value like '%//%'
    /* Only if onto_poster is portrait  */
        AND OntoPosterInfoResource.ResourceName = 'onto_poster_info'
        AND Yson::ConvertToBool(
            Yson::YPath(
                Yson::ParseJson(OntoPosterInfoResource.Value), 
                "/ImgIsPortrait"
            )
        ) = true
    /* Only for Ya.Main (Morda) */
        AND ContentGroup.TMP_OvsServiceFlags like '%ya-main%'
    /* Only Active Documents */
        AND ContentGroup.Options not like '%"deleted"%'
    /* Without Catchups */
        AND ContentType.Name IN (
            "ott-movie",        /* OTT-Фильмы */
            "ntv-vod-movie",    /* Канальные фильмы */
            "vod-episodes",     /* Страые канальные фильмы */
            
        )
ORDER BY 
    ContentType.Name;
        
        