use hahn;
pragma yson.DisableStrict;
pragma yt.Pool = "@[pool]";
-- pragma yt.DataSizePerJob = "256M";
-- pragma yt.MaxJobCount = "99999";
-- pragma config.flags("LLVM", "OFF");
pragma library("stability_common.sql");
pragma yt.DefaultMemoryLimit = "1G";
import stability_common symbols $parseDate, $shiftDate, $dateRange;
-- pragma library("lib_humans_0.sql");
-- pragma library("lib_humans_1.sql");
-- import lib_humans_0 symbols $get_human_cryptaids;

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$input_root = "//home/videoquality/vh_analytics/ad_squeeze_campaigns";
$output_table = "@[output_table]";

$getMaxImprBudget = ($sp, $date_from, $date_to) -> {
    $date_from = CAST($date_from as Date);
    $date_to = CAST($date_to as Date);
    $finish = CAST(Yson::LookupString($sp, "finish") as Date);
    $start = CAST(Yson::LookupString($sp, "start") as Date);
    $days = DateTime::ToDays($finish - $start);
    return IF(
        $finish < $date_from or $start > $date_to,
        null,
        Yson::LookupDouble($sp, "budget") / $days
    )
};

$getDayBudget = ($sp, $db, $date_from, $date_to) -> {
    $name = Yson::LookupString($sp, "name");
    return case
    when $name == "autobudget_max_reach" then Yson::LookupDouble($sp, "sum") / 7.0
    when $name == "autobudget_max_reach_custom_period" then $getMaxImprBudget($sp, $date_from, $date_to)
    when $name == "cpm_default" then CAST($db as Double)
    else null
    end
};

$flights_tmp = (
    select
        campaign_nmb,
        flight_nmb,
        substring(min(date_begin), 0, 10) as date_begin,
        $shiftDate(substring(max(date_end), 0, 10), -1) as date_end
    from `//home/inventory/ado_dictionaries/flight`
    group by campaign_nmb,
        flight_nmb
);

$flights = (
    select
        *
    from $flights_tmp
    where not (date_end < $date_from or date_begin > $date_to)
);

$flights_join_data = (
    select f.*,
        campaign_name,
        advertiser_name as client_name,
        "awaps" as campaign_type,
        Math::Round(min_of(b.amount, b.amount_accepted * 100. / (100 + vat))) as price_plan
    from $flights as f
    left join any `//home/inventory/ado_dictionaries/campaign` as c on (f.campaign_nmb == c.campaign_nmb)
    left join any `//home/awaps/db/adoffice/ado_current/t_buying` as b on (
        f.flight_nmb == b.nmb
    )
);

$flights_join_transform_1 = (
    select
        $dateRange(date_begin, date_end) as fielddate,
        price_plan / CAST(DateTime::ToDays(CAST(date_end as Date) - CAST(date_begin as Date)) as Double) as day_budget,
        f.* without price_plan, date_begin, date_end
    from $flights_join_data as f
);

$flights_join_transform_2 = (
    select
        *
    from $flights_join_transform_1
    flatten list by fielddate
);

$awaps_campaigns_data = (
    select
        cid,
        fielddate,
        "awaps" as campaign_type,
        some(client_name) as client_name,
        sum(day_budget) as day_budget
    from $flights_join_transform_2
    group by campaign_nmb as cid,
        fielddate
);

$ado_cube_data = (
    select
        report_date as fielddate,
        flight_nmb,
        amount_realized_rub_gross_w_nds
    from `//home/comdep-analytics/YAN/cubes/ado/stats/schedule_resource_stats`
    where report_date >= $date_from and report_date <= $date_to
);

$ado_cube_data_joined = (
    select
        a.*,
        campaign_name,
        advertiser_name,
        ac.campaign_nmb as cid
    from $ado_cube_data as a
    left join any `//home/awaps/cooked/flight` as af on (
        a.flight_nmb == af.flight_nmb
    )
    left join any `//home/awaps/cooked/campaign` as ac on (
        af.campaign_nmb == ac.campaign_nmb
    )
);

$ado_cube_data_grouped = (
    select
        cid,
        fielddate,
        "awaps" as campaign_type,
        some(advertiser_name) as client_name,
        sum(amount_realized_rub_gross_w_nds) as money_gross_ado_cube
    from $ado_cube_data_joined
    group by cid, fielddate
);

$campaigns_data = (
    select
        cid,
        curr_counterparty_name ?? client_name ?? CAST(ClientID as String) as client_name,
        Yson::LookupString(strategy_params, "name") as campaign_type,
        $getDayBudget(strategy_params, day_budget, $date_from, $date_to) as day_budget,
        OrderID,
        statusActive,
        statusShow,
        statusModerate,
        day_budget as day_budget_unprocessed,
        strategy_params
    from `//home/direct/db/campaigns` as camp
    left join any `//home/comdep-analytics/public/client_tiers/fact/latest` as clients on (camp.ClientID == clients.client_id)
    where currency == "RUB" and $getDayBudget(strategy_params, day_budget, $date_from, $date_to) is not null
    and statusActive == "Yes" and statusShow == "Yes" and statusModerate == "Yes" and OrderID != 0
);

insert into `//home/videoquality/vh_analytics/ad_cube_campaigns_v2/@[date_from]_@[date_to]/campaigns` WITH TRUNCATE 
select * from $campaigns_data;

$totalize = ($row) -> {
    $result = AsList($row);
    $add = ListMap(
        $result,
        ($x)->(AddMember(RemoveMember($x, "campaign_type"), "campaign_type", "_total_"))
    );
    $result = ListUnionAll($result, $add);
    $add = ListMap(
        $result,
        ($x)->(AddMember(RemoveMember($x, "producttype"), "producttype", "_total_"))
    );
    $result = ListUnionAll($result, $add);
    $add = ListMap(
        $result,
        ($x)->(AddMember(RemoveMember($x, "client_name"), "client_name", "_total_"))
    );
    $result = ListUnionAll($result, $add);
    $add = ListMap(
        $result,
        ($x)->(AddMember(RemoveMember($x, "cid"), "cid", "_total_"))
    );
    $result = ListUnionAll($result, $add);
    return $result
};

$ctotalize = ($row) -> {
    $result = AsList($row);
    $add = ListMap(
        $result,
        ($x)->(AddMember(RemoveMember($x, "campaign_type"), "campaign_type", "_total_"))
    );
    $result = ListUnionAll($result, $add);
    $add = ListMap(
        $result,
        ($x)->(AddMember(RemoveMember($x, "client_name"), "client_name", "_total_"))
    );
    $result = ListUnionAll($result, $add);
    $add = ListMap(
        $result,
        ($x)->(AddMember(RemoveMember($x, "cid"), "cid", "_total_"))
    );
    $result = ListUnionAll($result, $add);
    return $result
};

$source_ = (
    select
        s.fielddate as fielddate,
        CAST(s.cid as String) ?? "-" as cid,
        yandexuid,
        crypta_id,
        producttype,
        winhits,
        shows,
        price,
        c.client_name ?? a.client_name ?? ag.client_name as client_name,
        c.campaign_type ?? a.campaign_type ?? ag.campaign_type as campaign_type,
        c.day_budget ?? a.day_budget as day_budget,
        money_gross_ado_cube
    from (
        select *
        from
        range(
            $input_root, $date_from, $date_to
        )
        where winhits > 0 or shows > 0 or price > 0
    ) as s
    left join any $campaigns_data as c on (s.cid == c.cid)
    left join any $awaps_campaigns_data as a on (s.cid == a.cid and s.fielddate == a.fielddate)
    left join any $ado_cube_data_grouped as ag on (s.cid == ag.cid and s.fielddate == ag.fielddate)
);

$source = select * from $source_ where client_name is not null;

$nwrap = ($x) -> (IF(CAST($x as String) in ("inf", "-inf", "nan"), null, $x));

$uniq_by_day = (
    select
        fielddate,
        client_name,
        cid,
        $nwrap(some(day_budget)) as day_budget,
        $nwrap(some(money_gross_ado_cube)) as money_gross_ado_cube,
        some(campaign_type) as campaign_type
    from $source
    group by fielddate,
        client_name,
        cid
);

$clients_data_grouped = (
    select
        fielddate,
        client_name,
        campaign_type,
        cid,
        sum(day_budget) as day_budget,
        sum(money_gross_ado_cube) as money_gross_ado_cube
    from (process $uniq_by_day using $ctotalize(TableRow()))
    group by fielddate, client_name, campaign_type, cid
);

$totalized = process $source using $totalize(TableRow());

$grouped = (
    select
        fielddate,
        client_name,
        cid,
        campaign_type,
        producttype,
        $nwrap(SUM(price) / 1000000.0) as price,
        $nwrap(SUM(shows)) as shows,
        $nwrap(SUM(winhits)) as winhits,
        CountDistinctEstimate(yandexuid) as yandexuids,
        CountDistinctEstimate(crypta_id) as crypta_ids,
    from $totalized
    group by fielddate, client_name, cid, campaign_type, producttype
);

$grouped_joined = (
    select
        g.cid as campaign_id,
        $nwrap(day_budget) as day_budget,
        $nwrap(money_gross_ado_cube) as money_gross_ado_cube,
        g.* without g.cid
    from $grouped as g
    left join any $clients_data_grouped as c using (fielddate, client_name, campaign_type, cid)
);

insert into $output_table with truncate
select * from $grouped_joined;
