use hahn;
pragma AnsiInForEmptyOrNullableItemsCollections;

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$output_table = "@[output_table]";

$source = (
    select
        *
    from range(
        `//home/videoquality/vh_analytics/ad_fraud_logins`, $date_from, $date_to
    )
);

$totalize = ($row) -> {
    $result = AsList($row);
    $add = ListMap(
        $result,
        ($x)->(AddMember(RemoveMember($x, "login"), "login", "_total_"))
    );
    $result = ListUnionAll($result, $add);
    $add = ListMap(
        $result,
        ($x)->(AddMember(RemoveMember($x, "ad_type"), "ad_type", "_total_"))
    );
    $result = ListUnionAll($result, $add);
    $add = ListMap(
        $result,
        ($x)->(AddMember(RemoveMember($x, "video_type"), "video_type", "_total_"))
    );
    $result = ListUnionAll($result, $add);
    $add = ListMap(
        $result,
        ($x)->(AddMember(RemoveMember($x, "devicetype"), "devicetype", "_total_"))
    );
    $result = ListUnionAll($result, $add);
    -- $add = ListMap(
    --     $result,
    --     ($x)->(AddMember(RemoveMember($x, "campaign_name"), "campaign_name", "_total_"))
    -- );
    -- $result = ListUnionAll($result, $add);
    $add = ListMap(
        $result,
        ($x)->(AddMember(RemoveMember($x, "detaileddevicetype"), "detaileddevicetype", "_total_"))
    );
    $result = ListUnionAll($result, $add);
    $add = ListMap(
        $result,
        ($x)->(AddMember(RemoveMember($x, "producttype"), "producttype", "_total_"))
    );
    $result = ListUnionAll($result, $add);
    $add = ListMap(
        $result,
        ($x)->(AddMember(RemoveMember($x, "browser_name"), "browser_name", "_total_"))
    );
    $result = ListUnionAll($result, $add);
    return $result
};
$totalized = process $source using $totalize(TableRow());

$grouped1 = (
    select
        fielddate,
        login,
        ad_type,
        video_type,
        devicetype,
        detaileddevicetype,
        browser_name,
        producttype,
        sum(hits) as hits,
        sum(winhits) as winhits,
        sum(efh_shows) as efh_shows,
        sum(efh_clicks) as efh_clicks,
        sum(efh_vclicks) as efh_vclicks,
        sum(efh_lclicks) as efh_lclicks,
        sum(efh_bounces) as efh_bounces,
        sum(renders) as renders,
        sum(completes) as completes,
        sum(EventCost) as eventcost,
        sum(chevent_shows) as chevent_shows,
        sum(eshows) as eshows,
        sum(efh_fraud) as fraud,
        sum(fraud_general) as fraud_general,
        sum(fraud_sophisticated) as fraud_sophisticated,
    from $totalized
    group by fielddate,
        login,
        ad_type,
        video_type,
        devicetype,
        detaileddevicetype,
        browser_name,
        producttype
);

insert into $output_table with truncate
select * from $grouped1
where hits >= 15000;

insert into `//home/videoquality/vh_analytics/KOAN-3297/report`
select * from $grouped1
order by fielddate, login, ad_type, browser_name, detaileddevicetype, devicetype,
video_type, producttype;

