use hahn;
pragma yt.Pool = "@[pool]";
pragma yt.DataSizePerJob = "256M";
PRAGMA yt.DataSizePerSortJob = "3G";
pragma yt.MaxJobCount = "99999";
pragma config.flags("LLVM", "OFF");
pragma library("stability_common.sql");
import stability_common symbols $parseDate, $shiftDate, $dateRange;
pragma library("lib_humans_0.sql");
pragma library("lib_humans_1.sql");
import lib_humans_0 symbols $get_human_cryptaids;

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$date_from_shifted = $shiftDate($date_from, -30);
/*output
$output_table = "@[output_table]";
output*/

$source = (
    select
        unwrap(pageid) as pageid,
        unwrap(impid) as impid,
        unwrap(yandexuid) as yandexuid,
        s.* without pageid, impid, yandexuid
    from range(
        `@[input_root]`, $date_from_shifted, $date_to
    ) as s
);

$get_last_10 = ($s) -> {
    $len = Length($s);
    return substring($s, cast($len - 10 as Uint32))
};

$nullify_fresh = ($yu, $fd) -> {
    $last10 = CAST($get_last_10(CAST($yu as String)) as Uint32);
    $fd_parsed = $parseDate($fd);
    $fd_from_yu = DateTime::MakeDate(DateTime::FromSeconds($last10));
    return IF(
        $fd_from_yu is null or $fd_from_yu >= $fd_parsed,
        null,
        $yu
    )
};

$nullify_zero = ($c) -> (IF($c == 0, NULL, $c));

$tmp =(
    select
        fielddate,
        video_type,
        category,
        producttype,
        gender ?? "unknown" as gender,
        income_segment ?? "unknown" as income_segment,
        age_segment ?? "unknown" as age_segment,
        crypta_id,
        IF(
            $nullify_fresh(yandexuid, fielddate) is null,
            null,
            crypta_id
        ) as crypta_id_nonfresh_only,
        $nullify_zero(crypta_id) ?? $nullify_fresh(yandexuid, fielddate) as crypta_id_plus_nonfresh_yu,
        yandexuid,
        $nullify_fresh(yandexuid, fielddate) as yandexuid_non_fresh,
        video_content_id ?? referer as content_id,
        shows_block,
        shows,
        winhits_block,
        winhits,
        hits_block,
        hits,
        price,
        partnerprice,
        CAST(dspmincpm as Uint64) as dspmincpm,
        CAST(selfmincpm as Uint64) as selfmincpm,
        CAST(effective_mincpm as Uint64) as effective_mincpm
    from $source
);

$without_crypta_ids = (
    select * from $tmp where crypta_id is null or crypta_id == 0
);

$with_crypta_id = (
    select * from $tmp where crypta_id is not null or crypta_id != 0
);

$lastDateCheck = ($fd, $lad) -> {
    $fd = $parseDate($fd);
    $lad = $parseDate($lad);
    $diff = DateTime::ToDays($fd - $lad);
    return $fd is not null
    and $lad is not null
    and $diff is not null
    and $diff <= 30
};

$tmp_plus_humans = (
    select t.*, cryptaId as crypta_id_human, last_active_date
    from $with_crypta_id as t
    left join $get_human_cryptaids() as h on (t.crypta_id == CAST(h.cryptaId as UInt64))
);

$after_humans_join = (
    select * from $tmp_plus_humans
    union all
    select * from $without_crypta_ids
);

$totalizeCategory = ($row) -> (IF(
    $row.category like "%VH%" or $row.category like "%vh%",
    AsList(
        AddMember(RemoveMember($row, "category"), "category", "_total_"),
        AddMember(RemoveMember($row, "category"), "category", "_vh_")
    ),
    AsList(AddMember(RemoveMember($row, "category"), "category", "_total_")),
));

$totalize = ($row) -> {
    $result = AsList($row);
    $add = ListMap(
        $result,
        ($x)->(AddMember(RemoveMember($x, "gender"), "gender", "_total_"))
    );
    $result = ListUnionAll($result, $add);
    $add = ListMap(
        $result,
        ($x)->(AddMember(RemoveMember($x, "income_segment"), "income_segment", "_total_"))
    );
    $result = ListUnionAll($result, $add);
    $add = ListMap(
        $result,
        ($x)->(AddMember(RemoveMember($x, "age_segment"), "age_segment", "_total_"))
    );
    $result = ListUnionAll($result, $add);
    $add = ListMap(
        $result,
        ($x)->(AddMember(RemoveMember($x, "video_type"), "video_type", "_total_"))
    );
    $result = ListUnionAll($result, $add);
    $add = ListFlatMap(
        $result,
        $totalizeCategory
    );
    $result = ListUnionAll($result, $add);
    return $result
};

$totalized = process $after_humans_join using $totalize(TableRow());

$dim_1day = (
    select t.*, "1day" as window_size
    from $totalized as t
    where fielddate >= $date_from and fielddate <= $date_to
);

$dim_7days = (
    select * from (
        select
            "7days" as window_size,
            ListFilter($dateRange(
                fielddate,
                $shiftDate(fielddate, 7)
            ), ($x)->($x >= $date_from and $x <= $date_to)) as fielddate,
            t.* without t.fielddate
        from $totalized as t
        where fielddate >= $shiftDate($date_from, -7) and fielddate <= $date_to
    )
    flatten list by fielddate
);

$dim_30days = (
    select * from (
        select
            "30days" as window_size,
            ListFilter($dateRange(
                fielddate,
                $shiftDate(fielddate, 30)
            ), ($x)->($x >= $date_from and $x <= $date_to)) as fielddate,
            t.* without t.fielddate
        from $totalized as t
        where fielddate >= $shiftDate($date_from, -30) and fielddate <= $date_to
    )
    flatten list by fielddate
);

$grouping1_source = (
    select * from $dim_1day
    union all
    select * from $dim_7days
    union all
    select s.* without s.selfmincpm, s.dspmincpm, s.effective_mincpm from $dim_30days as s
);

$grouped1 = (
    select
        window_size,
        fielddate,
        video_type,
        category,
        gender,
        income_segment,
        age_segment,
        CountDistinctEstimate(yandexuid) as yandexuids,
        CountDistinctEstimate(crypta_id) as crypta_ids,
        CountDistinctEstimate(IF(
            crypta_id_human is not null and $lastDateCheck(fielddate, last_active_date),
            crypta_id_human
        )) as crypta_ids_human,
        CountDistinctEstimate(crypta_id_nonfresh_only) as crypta_ids_nonfresh_only,
        CountDistinctEstimate(crypta_id_plus_nonfresh_yu) as crypta_ids_plus_nonfresh_yu,
        CountDistinctEstimate(yandexuid_non_fresh) as yandexuids_non_fresh,
        CountDistinctEstimate(content_id) as content_ids,
    from $grouping1_source
    group by
        window_size,
        fielddate,
        video_type,
        category,
        gender,
        income_segment,
        age_segment

);

$grouped2 = (
    select
        window_size,
        fielddate,
        video_type,
        category,
        gender,
        income_segment,
        age_segment,
        sum(shows_block) as shows_block,
        sum(shows) as shows,
        sum(winhits_block) as winhits_block,
        sum(winhits) as winhits,
        sum(price) as price,
        sum_if(price, producttype like "%reach%") as price_cpm,
        sum_if(price, producttype not like "%reach%") as price_cpc,
        sum(partnerprice) as partnerprice,
        sum(hits_block) as hits_block,
        sum(hits) as hits,
        MEDIAN(selfmincpm) as selfmincpm,
        MEDIAN(dspmincpm) as dspmincpm,
        MEDIAN(effective_mincpm) as effective_mincpm
    from $grouping1_source
    group by
        window_size,
        fielddate,
        video_type,
        category,
        gender,
        income_segment,
        age_segment

);

-- 1,2-3,4-10,10+ показами рекламы

$yandexuids_shows_group = (
    select
        window_size,
        fielddate,
        video_type,
        category,
        gender,
        income_segment,
        age_segment,
        CountDistinctEstimate(IF(shows == 1, yandexuid_non_fresh, null)) as yandexuids_with_1_shows,
        CountDistinctEstimate(IF(shows == 2 or shows == 3, yandexuid_non_fresh, null)) as yandexuids_with_2_3_shows,
        -- CountDistinctEstimate(IF(shows >= 4 and shows <= 10, yandexuid_non_fresh, null)) as yandexuids_with_4_10_shows,
        CountDistinctEstimate(IF(shows >= 11, yandexuid_non_fresh, null)) as yandexuids_with_11_plus_shows,
        CountDistinctEstimate(IF(hits == 1, yandexuid_non_fresh, null)) as yandexuids_with_1_hits,
        CountDistinctEstimate(IF(hits == 2 or hits == 3, yandexuid_non_fresh, null)) as yandexuids_with_2_3_hits,
        -- CountDistinctEstimate(IF(hits >= 4 and hits <= 10, yandexuid_non_fresh, null)) as yandexuids_with_4_10_hits,
        CountDistinctEstimate(IF(hits >= 11, yandexuid_non_fresh, null)) as yandexuids_with_11_plus_hits,
    from (
        select
            window_size,
            fielddate,
            video_type,
            category,
            gender,
            income_segment,
            age_segment,
            yandexuid_non_fresh,
            sum(shows) as shows,
            sum(hits) as hits
        from $grouping1_source
        group by
            window_size,
            fielddate,
            video_type,
            category,
            gender,
            income_segment,
            age_segment,
            yandexuid_non_fresh
    )
    group by
        window_size,
        fielddate,
        video_type,
        category,
        gender,
        income_segment,
        age_segment
);

$crypta_ids_shows_group = (
    select
        window_size,
        fielddate,
        video_type,
        category,
        gender,
        income_segment,
        age_segment,
        CountDistinctEstimate(IF(shows == 1, crypta_id_human, null)) as crypta_ids_with_1_shows,
        CountDistinctEstimate(IF(shows == 2 or shows == 3, crypta_id_human, null)) as crypta_ids_with_2_3_shows,
        -- CountDistinctEstimate(IF(shows >= 4 and shows <= 10, crypta_id_human, null)) as crypta_ids_with_4_10_shows,
        CountDistinctEstimate(IF(shows >= 11, crypta_id_human, null)) as crypta_ids_with_11_plus_shows,
        CountDistinctEstimate(IF(hits == 1, crypta_id_human, null)) as crypta_ids_with_1_hits,
        CountDistinctEstimate(IF(hits == 2 or hits == 3, crypta_id_human, null)) as crypta_ids_with_2_3_hits,
        -- CountDistinctEstimate(IF(hits >= 4 and hits <= 10, crypta_id_human, null)) as crypta_ids_with_4_10_hits,
        CountDistinctEstimate(IF(hits >= 11, crypta_id_human, null)) as crypta_ids_with_11_plus_hits,
    from (
        select
            window_size,
            fielddate,
            video_type,
            category,
            gender,
            income_segment,
            age_segment,
            crypta_id_human,
            sum(shows) as shows,
            sum(hits) as hits
        from $grouping1_source
        where crypta_id_human is not null
        group by
            window_size,
            fielddate,
            video_type,
            category,
            gender,
            income_segment,
            age_segment,
            crypta_id_human
    )
    group by
        window_size,
        fielddate,
        video_type,
        category,
        gender,
        income_segment,
        age_segment
);

$grouped_join = (
    select g.*,
    shows_block,
    shows,
    winhits_block,
    winhits,
    price,
    price_cpm,
    price_cpc,
    partnerprice,
    hits_block,
    hits,
    selfmincpm,
    dspmincpm,
    effective_mincpm,
    yandexuids_with_1_shows ?? 0 as yandexuids_with_1_shows,
    yandexuids_with_2_3_shows ?? 0 as yandexuids_with_2_3_shows,
    -- yandexuids_with_4_10_shows ?? 0 as yandexuids_with_4_10_shows,
    yandexuids_with_11_plus_shows ?? 0 as yandexuids_with_11_plus_shows,
    crypta_ids_with_1_shows ?? 0 as crypta_ids_with_1_shows,
    crypta_ids_with_2_3_shows ?? 0 as crypta_ids_with_2_3_shows,
    -- crypta_ids_with_4_10_shows ?? 0 as crypta_ids_with_4_10_shows,
    crypta_ids_with_11_plus_shows ?? 0 as crypta_ids_with_11_plus_shows,
    yandexuids_with_1_hits ?? 0 as yandexuids_with_1_hits,
    yandexuids_with_2_3_hits ?? 0 as yandexuids_with_2_3_hits,
    -- yandexuids_with_4_10_hits ?? 0 as yandexuids_with_4_10_hits,
    yandexuids_with_11_plus_hits ?? 0 as yandexuids_with_11_plus_hits,
    crypta_ids_with_1_hits ?? 0 as crypta_ids_with_1_hits,
    crypta_ids_with_2_3_hits ?? 0 as crypta_ids_with_2_3_hits,
    -- crypta_ids_with_4_10_hits ?? 0 as crypta_ids_with_4_10_hits,
    crypta_ids_with_11_plus_hits ?? 0 as crypta_ids_with_11_plus_hits
    from $grouped1 as g
    left join $grouped2 as g2 on (
        g.window_size == g2.window_size and
        g.fielddate == g2.fielddate and
        g.video_type == g2.video_type and
        g.category == g2.category and
        g.gender == g2.gender and
        g.income_segment == g2.income_segment and
        g.age_segment == g2.age_segment
    )
    left join $yandexuids_shows_group as y on (
        g.window_size == y.window_size and
        g.fielddate == y.fielddate and
        g.video_type == y.video_type and
        g.category == y.category and
        g.gender == y.gender and
        g.income_segment == y.income_segment and
        g.age_segment == y.age_segment
    )
    left join $crypta_ids_shows_group as c on (
        g.window_size == c.window_size and
        g.fielddate == c.fielddate and
        g.video_type == c.video_type and
        g.category == c.category and
        g.gender == c.gender and
        g.income_segment == c.income_segment and
        g.age_segment == c.age_segment
    )
);

$unwrap_dimensions = (
    select
        unwrap(window_size) as window_size,
        unwrap(fielddate) as fielddate,
        unwrap(video_type) as video_type,
        unwrap(category) as category,
        unwrap(gender) as gender,
        unwrap(income_segment) as income_segment,
        unwrap(age_segment) as age_segment,
        g.* without window_size,
        fielddate,
        video_type,
        category,
        gender,
        income_segment,
        age_segment
    from $grouped_join as g
    where fielddate is not null
    and video_type is not null
    and category is not null
    and gender is not null
    and income_segment is not null
    and age_segment is not null
);

/*output
insert into $output_table with truncate
select * from $unwrap_dimensions;
output*/

/*upsert
upsert into stat.`@[report]/daily`
select * from $unwrap_dimensions;
upsert*/