use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yt.ParallelOperationsLimit = "4";
pragma yt.Pool = "@[pool]";
pragma library("stability_common.sql");
import stability_common symbols $dateRange;
$date_from = "@[date_from]";
$date_to = "@[date_to]";
$output_root = "@[output_root]/";
$pageimps_table = "//home/bs/users/yabs-analytics/video/pageimp_ids_video_with_inapp";
$good_page_ids = select distinct pageid from $pageimps_table;
$good_dsp_ids = select distinct dspid from $pageimps_table;
$page_imp = (
    select
        pageid,
        impid,
        some(category) as category,
        some(video_placement_name) as ad_type,
        some(video_type) as video_type,
        some(category) like 'VH%' as is_vh,
        some(name) as partner_name,
    from $pageimps_table
    group by pageid, impid
);
$dspid_to_name = (
    select
        ToDict(AGGREGATE_LIST(AsTuple(dspid, dsp_name)))
    from (
        select
            unwrap(dspid) as dspid, unwrap(max(dsp_name)) as dsp_name
        from $pageimps_table
        group by dspid
    )
);
$undefWrapper = ($x) -> {
    RETURN IF(
        $x is null or $x in ("-", "undefined", "null", "", "0"),
        null,
        $x
    )
};
$nw = ($x) -> (IF($x is null, 0, $x));
$getEffectiveMinCPM = ($dspmincpm, $selfmincpm, $ps) -> {
    $max = CAST(MAX_OF($nw($dspmincpm), $nw($selfmincpm)) as Double);
    return IF(
        $ps is not null and $ps > 0,
        $max / $ps,
        $max
    )
};
define subquery $pre_map($date_from, $date_to) as
$map_ = (
    select
        TableName() as fielddate,
        pageid,
        uniqid as yandexuid,
        impid,
        dspid,
        adtype,
        countertype,
        `impressionoptions_yandex-page` or `impressionoptions_business-unit` as is_ya,
        win,
        price,
        partnerprice,
        $undefWrapper(Url::GetCGIParam("?" || queryargs, "354")) as video_content_id,
        Url::GetCGIParam("?" || queryargs, "769") as vsid,
        position,
        producttype,
        bidreqid,
        dspfraudbits,
        dspeventflags,
        maxadscount,
        devicetype,
        detaileddevicetype,
        referer,
        bidid,
        videoduration,
        IF(adtype like "%video%", dspmincpm) as dspmincpm,
        IF(adtype like "%video%", selfmincpm) as selfmincpm,
        IF(adtype like "%video%", $getEffectiveMinCPM(dspmincpm, selfmincpm, partnershare)) as effective_mincpm
    from range(`cooked_logs/bs-dsp-cooked-log/1d`, $date_from, $date_to) with unordered
);
$map = (
    select
        fielddate,
        pageid,
        yandexuid,
        impid,
        dspid,
        adtype,
        countertype,
        is_ya,
        win,
        price,
        partnerprice,
        vsid,
        position,
        producttype,
        bidreqid,
        devicetype,
        detaileddevicetype,
        bidid,
        IF(
            countertype == 0 and win == 1 and position == 0,
            maxadscount,
            0
        ) as hits,
        referer,
        video_content_id,
        videoduration,
        dspmincpm,
        selfmincpm,
        effective_mincpm
    from $map_
        where
    bidreqid is not null and bidreqid != 0
    and dspfraudbits == 0
    and dspeventflags == 0
    and pageid in $good_page_ids
    and (
        dspid in $good_dsp_ids
        or (
            countertype == 0
            and win == 1
            and dspid in (5, 10)
        )
    )
);

$chevent_ = (
    SELECT
        TableName() as fielddate,
        hitlogid,
        clientid,
        orderid
    from range(
        `//statbox/cooked_logs/bs-chevent-cooked-log/v2/1d`, $date_from, $date_to
    )
);

$awaps_ = (
    select
        TableName() as fielddate,
        cast(rtb_request_id as Uint64) as rtb_request_id,
        cast(placementid as Int32) as placementid
    from range(
        `//logs/awaps-log/1d`, $date_from, $date_to
    )
);

$client_ids = (
    select
        c.fielddate as fielddate,
        bidid,
        clientid,
        orderid,
        fio as advertiser_name,
        name as campaign_name,
        cid
    from $chevent_ as c
    inner join any $map as m on (
        c.fielddate == m.fielddate
        and c.hitlogid == m.bidid
    )
    left join any `//home/direct/db/campaigns` as camp on (
        c.orderid == camp.OrderID
        and c.clientid == camp.ClientID
    )
);

$awaps_client_ids = (
    select
        a.fielddate as fielddate,
        rtb_request_id,
        placementid,
        campaign_name,
        advertiser_name,
        ac.campaign_nmb as cid
    from $awaps_ as a
    inner join any $map as m on (
        a.fielddate == m.fielddate
        and a.rtb_request_id == m.bidreqid
    )
    left join any `//home/awaps/cooked/flight` as af on (
        a.placementid == af.awaps_placementid
    )
    left join any `//home/awaps/cooked/campaign` as ac on (
        af.campaign_nmb == ac.campaign_nmb
    )
);

$joined = (
    select
        m.*,
        IF(
            category == "other" and is_ya,
            "yandex",
            category
        ) as category,
        video_type,
        is_vh,
        partner_name
    from $map as m
    inner join any $page_imp as p using (pageid, impid)
);

$joined_p2 = (
    select
        j.*,
        clientid,
        orderid,
        cl.campaign_name ?? acl.campaign_name as campaign_name,
        cl.advertiser_name ?? acl.advertiser_name as advertiser_name,
        cl.cid ?? acl.cid as cid
    from $joined as j
    left join any $client_ids as cl on (
        j.fielddate == cl.fielddate
        and j.bidid == cl.bidid
    )
    left join any $awaps_client_ids as acl on (
        j.fielddate == acl.fielddate
        and j.bidreqid == acl.rtb_request_id
    )
);

$getProductType = ($di, $pt) -> (
    case
    when $di not in (1, 5, 10) and $dspid_to_name[$di] == "auction" then "awaps_auction"
    when $di not in (1, 5, 10) and $dspid_to_name[$di] == "price" then "awaps_fix_cpm"
    else $pt
    end
);

$reduce = (
    select
        fielddate,
        yandexuid,
        pageid,
        impid,
        dspid,
        is_vh,
        video_type,
        partner_name,
        category,
        referer,
        producttype,
        videoduration,
        video_content_id,
        clientid,
        orderid,
        cid,
        some(campaign_name) as campaign_name,
        some(advertiser_name) as advertiser_name,
        some(devicetype) as devicetype,
        some(detaileddevicetype) as detaileddevicetype,
        MAX(vsid) as vsid,
        SUM(hits) as hits,
        CountDistinctEstimate(bidreqid) as hits_block,
        COUNT_IF(countertype = 1 and win = 1 and dspid not in (5, 10) and adtype like "%video%") as shows,
        COUNT_IF(countertype = 1 and win = 1 and dspid not in (5, 10) and position = 0 and adtype like "%video%") as shows_block,
        sum_if(price, countertype = 1 and win = 1 and dspid not in (5, 10) and adtype like "%video%") as price,
        sum_if(partnerprice, countertype = 1 and win = 1 and dspid not in (5, 10) and adtype like "%video%") as partnerprice,
        COUNT_IF(countertype = 0 and win = 1 and dspid not in (5, 10) and adtype like "%video%") as winhits,
        COUNT_IF(countertype = 0 and win = 1 and dspid not in (5, 10) and position = 0 and adtype like "%video%") as winhits_block,
        MEDIAN(selfmincpm) as selfmincpm,
        MEDIAN(dspmincpm) as dspmincpm,
        MEDIAN(effective_mincpm) as effective_mincpm
    from $joined_p2
    where advertiser_name is not null and campaign_name is not null
    group by fielddate,
        yandexuid,
        pageid,
        impid,
        dspid,
        is_vh,
        video_type,
        partner_name,
        category,
        referer,
        video_content_id,
        $getProductType(dspid, producttype) as producttype,
        videoduration,
        clientid,
        orderid,
        cid
);
$ib = (
    select
        JoinKey,
        `UUID`,
        computed_channel,
        duration
    from `//home/videolog/strm_meta/iron_branch/concat`
);
$ib_non_joinable = (
    select * from $reduce where not is_vh or video_content_id is null
);
$ib_joinable = (
    select * from $reduce where is_vh and video_content_id is not null
);
$ib_joined = (
    select r.*, `UUID`, computed_channel, duration
    from $ib_joinable as r
    left join any $ib as i on (r.video_content_id == i.JoinKey)
);
$after_ib_join = (
    select * from $ib_non_joinable union all select * from $ib_joined
);
$crypta_non_joinable = (
    select * from $after_ib_join where yandexuid is null or yandexuid == 0
);
$crypta_joinable = (
    select * from $after_ib_join where yandexuid is not null and yandexuid != 0
);
$crypta_map_ = (
    select
        TableName() as fielddate,
        yandexuid,
        crypta_id,
        gender,
        user_age_6s,
        income_5_segments
    from range(
        `//statbox/crypta-yandexuid-profiles-log`, $date_from, $date_to
    )
);
$getMaxProbValue = ($yson) -> {
    $dict = DictItems(Yson::ConvertToDoubleDict($yson));
    return ListSortDesc($dict, ($x)->($x.1))[0].0
};
$crypta = (
    select
        fielddate,
        yandexuid,
        crypta_id,
        $getMaxProbValue(user_age_6s) as age_segment,
        $getMaxProbValue(gender) as gender,
        $getMaxProbValue(income_5_segments) as income_segment
    from $crypta_map_
);
$crypta_joined = (
    select r.*,
        crypta_id,
        gender,
        income_segment,
        age_segment
    from $crypta_joinable as r
    left join any $crypta as c using (yandexuid, fielddate)
);
$after_crypta_join = (
    select * from $crypta_non_joinable union all select * from $crypta_joined
);
select * from $after_crypta_join;
end define;
$pre_mapped = select * from $pre_map($date_from, $date_to);
define action $split_into_days($date) as
$output_table = $output_root || $date;
insert into $output_table with truncate
select * from $pre_mapped where fielddate == $date;
end define;
evaluate for $date in $dateRange($date_from, $date_to)
    do $split_into_days($date);
