use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yt.ParallelOperationsLimit = "4";
pragma yt.Pool = "@[pool]";
pragma library("stability_common.sql");
import stability_common symbols $dateRange;

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$output_root = "@[output_root]/";

$pageimps_table = "//home/bs/users/yabs-analytics/video/pageimp_ids_video_with_inapp";
$good_page_ids = select distinct pageid from $pageimps_table;
$page_imp = (
    select
        pageid,
        impid,
        some(category) as category,
        some(video_placement_name) as ad_type,
        some(video_type) as video_type,
        some(login) as login,
        some(name) as name,
        some(is_inapp) as is_inapp
    from $pageimps_table
    group by pageid, impid
);

$undefWrapper = ($x) -> {
    RETURN IF(
        $x is null or $x in ("-", "undefined", "null", "", "0"),
        null,
        $x
    )
};

$nw = ($x) -> (IF($x is null, 0, $x));

$getEffectiveMinCPM = ($dspmincpm, $selfmincpm, $ps) -> {
    $max = CAST(MAX_OF($nw($dspmincpm), $nw($selfmincpm)) as Double);
    return IF(
        $ps is not null and $ps > 0,
        $max / $ps,
        $max
    )
};

$get_device_type = ($devicetype, $useragent, $is_inapp) -> {
    return case
    when UserAgent::Parse($useragent).isTV then "smart_tv"
    when $is_inapp = true then "mobile_inapp"
    when $devicetype < 5 then "mobile"
    else "desktop"
    end
};

define subquery $pre_map($date_from, $date_to) as

$map_ = (
    select
        TableName() as fielddate,
        pageid,
        adtype,
        uniqid as yandexuid,
        `impressionoptions_yandex-page` or `impressionoptions_business-unit` as is_ya,
        impid,
        dspid,
        countertype,
        win,
        price,
        partnerprice,
        $undefWrapper(Url::GetCGIParam("?" || queryargs, "354")) as video_content_id,
        Url::GetCGIParam("?" || queryargs, "769") as vsid,
        position,
        producttype,
        bidreqid,
        dspfraudbits,
        dspeventflags,
        maxadscount,
        referer,
        videoduration,
        bidid,
        creativeid,
        devicetype,
        detaileddevicetype,
        useragent,
        browsername,
        IF(adtype like "%video%", selfmincpm) as selfmincpm,
        IF(adtype like "%video%", dspmincpm) as dspmincpm,
        IF(adtype like "%video%", $getEffectiveMinCPM(dspmincpm, selfmincpm, partnershare)) as effective_mincpm
    from range(`cooked_logs/bs-dsp-cooked-log/1d`, $date_from, $date_to) with unordered
);

$chevent_map_ =(
    select
        TableName() as fielddate,
        rtbbidreqid,
        hitlogid,
        creativeid,
        countertype,
        eshow,
        pageid,
        mrc_rules_categories
    from range(
        `//statbox/cooked_logs/bs-chevent-cooked-log/v2/1d`, $date_from, $date_to
    ) with unordered
);

$chevent_map = (
    select
        fielddate,
        hitlogid,
        creativeid,
        countertype,
        IF(mrc_rules_categories == "general", 1, 0) as fraud_general,
        IF(mrc_rules_categories == "sophisticated", 1, 0) as fraud_sophisticated,
        IF(countertype == 1, eshow) as eshow,
    from $chevent_map_
    where countertype in (1, 2)
    and pageid in $good_page_ids
);

$chevent_reduce = (
    select
        fielddate,
        hitlogid,
        creativeid,
        MAX(eshow) as eshow,
        sum(fraud_general) as fraud_general,
        sum(fraud_sophisticated) as fraud_sophisticated,
    from $chevent_map
    group by fielddate,
        hitlogid,
        creativeid
);

$efh_map_ = (
    select
        TableName() as fielddate,
        VisitIsBounce,
        HitLogID,
        CreativeID,
        HasCounter,
        EventCost,
        FraudBits,
        CounterType,
        PageID,
        ProductType
    from range(
        `//home/bs/logs/JoinedEFH/1h`, $date_from || "T00:00:00", $date_to || "T23:00:00"
    )
);

$efh_map = (
    select
        substring(fielddate, 0, 10) as fielddate,
        HitLogID,
        CreativeID,
        EventCost,
        IF(FraudBits != 0, 1, 0) as efh_fraud,
        IF(FraudBits = 0 and CounterType == 1, 1, 0) as efh_show,
        IF(FraudBits = 0 and CounterType == 2, 1, 0) as efh_click,
        IF(FraudBits = 0 and CounterType == 2 and HasCounter == 1, 1, 0) as efh_vclick,
        IF(FraudBits = 0 and CounterType == 2 and HasCounter == 1 and VisitIsBounce == 0, 1, 0) as efh_lclick,
        IF(FraudBits = 0 and CounterType == 2 and HasCounter == 1 and VisitIsBounce == 1, 1, 0) as efh_bounce,
    from $efh_map_
    where CounterType in (1, 2)
    and PageID in $good_page_ids
    and ProductType like "%video%"
);

$efh_reduce = (
    select
        fielddate,
        HitLogID,
        CreativeID,
        SUM(efh_fraud) as efh_fraud,
        MAX(efh_show) as efh_show,
        MAX(efh_click) as efh_click,
        MAX(efh_vclick) as efh_vclick,
        MAX(efh_lclick) as efh_lclick,
        MAX(efh_bounce) as efh_bounce,
        SUM(EventCost) as EventCost,
    from $efh_map
    group by fielddate,
        HitLogID,
        CreativeID
);

$chtracking_map_ = (
    select
        TableName() as fielddate,
        `action`,
        `hitlogid`,
        producttype,
        pageid,
        creativeid,
        fraudbits
    from range(
        `//logs/bs-chtracking-log/1d`, $date_from, $date_to
    )
);

$chtracking_map = (
    select
        fielddate,
        IF(`action` == "render", 1, 0) as render,
        IF(`action` == "complete", 1, 0) as complete,
        CAST(hitlogid as Uint64) as hitlogid,
        CAST(creativeid as UInt64) as creativeid
    from $chtracking_map_ as c
    where
        CAST(pageid as Int64) in $good_page_ids
        and `action` in ("render", "complete")
        and producttype like "%video%"
        and fraudbits = "0"
);


$chtracking_reduce = (
    select
        fielddate,
        hitlogid,
        creativeid,
        MAX(render) as render,
        MAX(complete) as complete
    from $chtracking_map
    group by fielddate,
        hitlogid,
        creativeid
);


$map = (
    select
        fielddate,
        adtype,
        pageid,
        is_ya,
        yandexuid,
        impid,
        dspid,
        countertype,
        win,
        price,
        partnerprice,
        vsid,
        position,
        producttype,
        bidreqid,
        IF(
            countertype == 0 and win == 1 and position == 0,
            maxadscount,
            0
        ) as hits,
        referer,
        video_content_id,
        videoduration,
        dspmincpm,
        selfmincpm,
        effective_mincpm,
        bidid as hitlogid,
        creativeid,
        dspfraudbits,
        dspeventflags,
        devicetype,
        useragent,
        browsername ?? "Unknown" as browser_name,
        IF(
            detaileddevicetype in ('iOS', 'MacOS', 'Windows', 'Android'),
            detaileddevicetype,
            'other'
        ) as detaileddevicetype
    from $map_
        where
    bidreqid is not null and bidreqid != 0
    -- and dspfraudbits == 0  --don't filter out fraudbits/eventflags for join with chevent/efh
    -- and dspeventflags == 0
    and pageid in $good_page_ids
    and (
        dspid == 1
        or (
            countertype == 0
            and win == 1
            and dspid in (5, 10)
        )
    )
);

$joined_dsp_1 = (
    select
        m.*,
        IF(
            category == "other" and is_ya,
            "yandex",
            category
        ) as category,
        video_type,
        ad_type,
        (login ?? "") || " - " || (name ?? "") as login,
        is_inapp
    from $map as m
    inner join $page_imp as p using (pageid, impid)
);

$joined_dsp_2 = (
    select
        $get_device_type(
            devicetype,
            useragent,
            is_inapp
        ) as devicetype,
        m.* without is_inapp, devicetype
    from $joined_dsp_1 as m
);

$dsp_shows = select * from $joined_dsp_2 where countertype == 1;
$dsp_other = select * from $joined_dsp_2 where countertype != 1;

$dsp_other_reduce = (
    select
        fielddate,
        login,
        ad_type,
        video_type,
        devicetype,
        detaileddevicetype,
        producttype,
        SUM(hits) as hits,
        COUNT_IF(countertype = 0 and win = 1 and dspid not in (5, 10) and adtype like "%video%") as winhits,
    from $dsp_other
    where dspeventflags == 0 and dspfraudbits == 0
    group by fielddate,
        login,
        ad_type,
        video_type,
        devicetype,
        detaileddevicetype,
        producttype
);

$dsp_shows_reduce = (
    select
        fielddate,
        login,
        ad_type,
        video_type,
        hitlogid,
        creativeid,
        devicetype,
        detaileddevicetype,
        browser_name,
        producttype
    from $dsp_shows
    group by fielddate,
        login,
        ad_type,
        video_type,
        hitlogid,
        creativeid,
        devicetype,
        detaileddevicetype,
        browser_name,
        producttype
);

$dsp_shows_joined = (
    select
        d.*,
        efh_show,
        efh_click,
        efh_vclick,
        efh_lclick,
        efh_bounce,
        EventCost,
        eshow,
        efh_fraud,
        fraud_general,
        fraud_sophisticated,
        render,
        complete
    from $dsp_shows_reduce as d
    left join any $efh_reduce as er on (
        d.hitlogid == er.HitLogID
        and d.creativeid == er.CreativeID
        and d.fielddate == er.fielddate
    )
    left join any $chevent_reduce as cr on (
        d.hitlogid == cr.hitlogid
        and d.creativeid == cr.creativeid
        and d.fielddate == cr.fielddate
    )
    left join any $chtracking_reduce as chr on (
        d.hitlogid == chr.hitlogid
        and d.creativeid == chr.creativeid
        and d.fielddate == chr.fielddate
    )
);

$dsp_shows_joined_reduce = (
    select
        fielddate,
        login,
        ad_type,
        video_type,
        devicetype,
        detaileddevicetype,
        browser_name,
        producttype,
        SUM(efh_show) ?? 0 as efh_shows,
        SUM(efh_click) ?? 0 as efh_clicks,
        SUM(efh_vclick) ?? 0 as efh_vclicks,
        SUM(efh_lclick) ?? 0 as efh_lclicks,
        SUM(efh_bounce) ?? 0 as efh_bounces,
        SUM(EventCost) ?? 0 as EventCost,
        COUNT(*) as chevent_shows,
        sum(eshow) ?? 0 as eshows,
        sum(fraud_general) as fraud_general,
        sum(fraud_sophisticated) as fraud_sophisticated,
        sum(efh_fraud) as efh_fraud,
        sum(render) ?? 0 as renders,
        sum(complete) ?? 0 as completes
    from $dsp_shows_joined
    group by fielddate,
        login,
        ad_type,
        video_type,
        devicetype,
        detaileddevicetype,
        browser_name,
        producttype
);

$all_joined = (
    select
        d.*,
        hits ?? 0 as hits,
        winhits ?? 0 as winhits
    from $dsp_shows_joined_reduce as d
    left join $dsp_other_reduce as o using (
        fielddate,
        login,
        ad_type,
        video_type,
        devicetype,
        detaileddevicetype,
        producttype
    )
);


select * from $all_joined;
end define;

$pre_mapped = select * from $pre_map($date_from, $date_to);

define action $split_into_days($date) as
$output_table = $output_root || $date;
insert into $output_table with truncate
select * from $pre_mapped where fielddate == $date;
end define;

evaluate for $date in $dateRange($date_from, $date_to)
    do $split_into_days($date);
