use hahn;
pragma yt.Pool = "@[pool]";

$date_from = "@[date_from]";
$date_to = "@[date_to]";


$tmp = (
select
    fielddate,
    pageid,
    description,
    count(*) as cnt
from (
    select
        TableName() as fielddate,
        cast(pageid as Int32) as pageid,
        description ?? "ok" as description
    from range(`//logs/bs-filter-log/1d`, $date_from, $date_to)
) as s
group by
    fielddate, pageid, description
);

$totals = (
    select
        fielddate, pageid, sum(cnt) as total
    from $tmp
    group by fielddate, pageid
);

$inapp = "//home/bs/users/yabs-analytics/video/pageimp_ids_video_with_inapp";

$jnd = (
    select t.*, login, total, cnt / cast(total as Double) as share
    from $tmp as t
    left join any $totals as tot on (t.fielddate == tot.fielddate and t.pageid == tot.pageid)
    inner join any $inapp as i on (t.pageid == i.pageid)
);

$add_totals = (
    select * from $jnd
    union all
    select s.*, "_total_" as description, 1.0 as share from $totals as s
);

upsert into stat.`@[report]/daily`
select
    unwrap((cast(pageid as String) ?? "") || " " || (login ?? "-")) as pageid,
    unwrap(fielddate) as fielddate,
    unwrap(description) as description,
    s.* without pageid, login, fielddate, description
from $add_totals as s