#!/usr/bin/env python
# -*- coding: utf-8 -*-
import sys
import os
import codecs
import argparse
import subprocess
import shlex
from videolog_common import date_range


def process_date(date):
    subprocess.check_call(shlex.split(
        f'python ad_squeeze_regular.py --query_stub ad_squeeze_fraud_stub.sql --root //home/videoquality/vh_analytics/ad_fraud_logins --title "Ad Squeeze Fraud | YQL" --from {date} --to {date}'
    ))
    subprocess.check_call(shlex.split(
        f'python ad_cube_regular.py --query_stub ad_cube_fraud_stub.sql --report Video/Others/VideoAdCubeFraud --title "[MMA-4860] Ad Cube Fraud" --root "//home/videoquality/vh_analytics/ad_cube_fraud_logins" --from {date} --to {date}'
    ))


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--from")
    parser.add_argument("--to")
    args = vars(parser.parse_args())

    for date in date_range(args["from"], args["to"]):
        process_date(date)


if __name__ == "__main__":
    main()
