USE Hahn;  -- hahn.yt.yandex.net
-- PRAGMA yt.DefaultCluster = 'hahn';
-- ========================================================================= --

-- TITLE: Crypta YQL [production] Run crypta metrics query
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

-- PRAGMA yt.PoolTrees = 'physical';
-- PRAGMA yt.TentativePoolTrees = 'cloud';


-- PRAGMA yt.StaticPool = 'crypta_graph';


-- ========================================================================= --

-- ========================================================================= --



-- DEFINE ACTION $DownloadUdf() AS
    

-- END DEFINE;
-- DO $DownloadUdf(); COMMIT;


DEFINE SUBQUERY $LAST_TABLE($dir) AS
    $table_name = Re2::Capture(@@^.*\/(?P<name>[^\/\.]+).*$@@);
    $max_table_name = (
        SELECT MAX($table_name(`Path`).name) AS name
        FROM FOLDER($dir, 'row_count')
        WHERE Type == 'table'
            AND Yson::LookupUint64(Attributes, 'row_count') > 0
    );

    SELECT *
    FROM LIKE($dir, $max_table_name);
END DEFINE;

$crypta_source_data = '//home/crypta/production/state/graph/v2/matching/workdir/output/vertices_no_multi_profile_by_id_type';
define subquery $crypta_edges_v2() as
    SELECT
        cryptaId AS crypta_id,
        id,
        id_type
    FROM $crypta_source_data;
end define;

define subquery $crypta_size_v2() as
    SELECT
        crypta_id,
        COUNT(1) AS crypta_id_size
    FROM (
        SELECT * FROM $crypta_edges_v2()
        WHERE id_type == 'yandexuid'
            OR id_type == 'devid'
    )
    GROUP BY crypta_id;
end define;

DEFINE SUBQUERY $CRYPTA_RAW() AS
    SELECT
        yandexuid_crypta.crypta_id AS crypta_id,
        yandexuid_crypta.yandexuid AS yandexuid,
        crypta_size.crypta_id_size AS crypta_id_size
    FROM (
        SELECT
            CAST(id AS Uint64) AS yandexuid,
            crypta_id
        FROM $crypta_edges_v2() WHERE id_type == 'yandexuid'
    ) AS yandexuid_crypta
    INNER JOIN $crypta_size_v2() AS crypta_size
    USING (crypta_id);
END DEFINE;


IMPORT lib_humans_1 SYMBOLS $evaluate_humans_1;

define subquery $get_human_cryptaids() as
select * from $evaluate_humans_1($LAST_TABLE, $CRYPTA_RAW);
end define;

export $get_human_cryptaids;
