USE Hahn;  -- hahn.yt.yandex.net
-- TITLE: Crypta YQL [production] Run crypta metrics query humans
PRAGMA yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$ru_region = 225;
-- Tables to use
$crypta_source_data = '//home/crypta/production/state/graph/v2/matching/workdir/output/vertices_no_multi_profile_by_id_type';
$edges_by_cryptaid = '//home/crypta/production/state/graph/v2/matching/edges_by_crypta_id';
$staff_output = '//home/crypta/production/state/graph/v2/matching/staff';
$yuid_with_all = '//home/crypta/production/state/graph/dicts/yuid_with_all';
$yuid_with_all_info = '//home/crypta/production/ids_storage/yandexuid/yuid_with_all_info';
$device_id_with_all_month = '//home/crypta/production/ids_storage/device_id/app_metrica_month';
$indevice = '//home/crypta/public/indevice/last';
$bs_chevent_cooked_log = '//cooked_logs/bs-chevent-cooked-log/1d/2020-06-29';
$bs_watch_cooked_log = '//cooked_logs/bs-watch-cooked-log/1d/2020-06-29';
$prepared_soup = '//home/crypta/production/state/graph/v2/soup/cooked/soup_edges';
$export_dir = '';

-- ========================================================================= --

DEFINE SUBQUERY $evaluate_humans_1($LAST_TABLE, $CRYPTA_RAW) AS
    -- PRAGMA yt.DefaultCluster = 'hahn';

    
    
    -- PRAGMA yt.PoolTrees = 'physical';
    -- PRAGMA yt.TentativePoolTrees = 'cloud';
    
    -- PRAGMA yt.StaticPool = 'crypta_graph';


$social = ('email', 'login', 'ok_id', 'vk_id', 'vk_name', 'fb_id');
$device = ('idfa', 'gaid', 'oaid', 'distr_r1', 'distr_ui');

$active_yuids_socials_devices = (
    select cryptaId, id, id_type, max(last_active_date) as last_active_date
    from (
        select cryptaId, id1Type as id_type, id1 as id, ListMax(dates) as last_active_date
        from $edges_by_cryptaid
        with COLUMNS Struct<dates: List<String>?>
        where (id1Type == "yandexuid" or id1Type in $social or id1Type in $device)
        union all
        select cryptaId, id2Type as id_type, id2 as id, ListMax(dates) as last_active_date
        from $edges_by_cryptaid
        with COLUMNS Struct<dates: List<String>?>
        where (id2Type == "yandexuid" or id2Type in $social or id2Type in $device)
    )
    group by cryptaId, id, id_type
);

$active_yuids = (
    select cryptaId, id, max(last_active_date) as last_active_date
    from $active_yuids_socials_devices
    where id_type == "yandexuid"
    group by cryptaId, id
);

$active_nonprivate_yuids_from_russia = (
    select t1.cryptaId as cryptaId, t1.id as id,
    t1.last_active_date as last_active_date,
    (t2.ua_profile like "d|desk|%") or (t2.ua_profile like "m|%") as is_device
    from $active_yuids as t1 join $yuid_with_all_info as t2 using(id)
    where (t2.main_region_country == 225 or t2.main_region_country is null) and t2.ip_activity_type not in ("private", "one_day")
);

$active_social_or_device = (
    select cryptaId, "social" as id_type, last_active_date
    from (
        select cryptaId, max(last_active_date) as last_active_date
        from $active_yuids_socials_devices
        where id_type in $social
        group by cryptaId
    )
    union all
    select cryptaId, "device" as id_type, last_active_date
    from (
        select cryptaId, max(last_active_date) as last_active_date
        from $active_yuids_socials_devices
        where id_type in $device
        group by cryptaId
    )
);

$devices_from_active_nonprivate_yuids_from_russia = (
    select cryptaId, 'device' as id_type, last_active_date
    from $active_nonprivate_yuids_from_russia
    where is_device
);

$summary = (
    select cryptaId, "yandexuid" as id_type, last_active_date
    from $active_nonprivate_yuids_from_russia
    union all
    select *
    from $active_social_or_device
    union all
    select *
    from $devices_from_active_nonprivate_yuids_from_russia
);

$cryptaid_like_human = (
    select cryptaId, AGGREGATE_LIST_DISTINCT(id_type) as id_types, max(last_active_date) as last_active_date
    from $summary
    group by cryptaId
);

$like_human = (
    select cryptaId, last_active_date
    from $cryptaid_like_human
    where ListHas(id_types, 'yandexuid') and ListHas(id_types, 'device') and ListHas(id_types, 'social')
);

-- ========================================================================= --


select * FROM $like_human;

END DEFINE;

-- ========================================================================= --
EXPORT $evaluate_humans_1;
