#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import os
import argparse
import datetime
import vh

try:
    basestring
except NameError:
    basestring = str

"""
To run: REQUESTS_CA_BUNDLE=/etc/ssl/certs/ python3 valhalla_ugc_push.py --from {date_from} --to {date_to}
"""

JOB_COMMAND = """bash -c 'python ${param["downloader"]!""} ${param["list_of_paths"]!""} ${param["string_of_paths"]!""} --token ${param["arcanum_token"]!""}[#if param["revision"]??] --revision ${param["revision"]}[/#if];\
export ARCANUM_REVISION=`cat arc_dl_revision.txt`;\
export ARCANUM_TOKEN=${param["arcanum_token"]};\
[#if param["yql_token"]??]export YQL_TOKEN=${param["yql_token"]};[/#if] \
export YT_TOKEN=${param["yt_token"]};\
export YT_PROXY=${param["yt_proxy"]};\
[#if param["stat_login"]??]export STAT_LOGIN=${param["stat_login"]};[/#if] \
[#if param["stat_token"]??]export STAT_TOKEN=${param["stat_token"]};[/#if] \
python ad_cube_regular.py --from @[date_from] --to @[date_to] \
--query_stub ad_cube_mma_4811.sql --report Video/Others/VideoAdCubeExternal \
--title "[MMA-4811] External Ad Report" \
--root "//home/videoquality/vh_analytics/ad_cube_external"'"""

list_of_paths = [
    "arcadia/analytics/videolog/strm-stats/mma_4767_ad_cube/ad_cube_regular.py",
    "arcadia/analytics/videolog/strm-stats/mma_4767_ad_cube/ad_cube_mma_4811.sql",
    "arcadia/analytics/videolog/videolog_common.py",
]


def date_range(from_, to_):
    if isinstance(from_, basestring):
        from_ = datetime.datetime.strptime(from_, "%Y-%m-%d").date()
    if isinstance(to_, basestring):
        to_ = datetime.datetime.strptime(to_, "%Y-%m-%d").date()
    mvr = min([from_, to_])
    result = []
    while mvr <= max([from_, to_]):
        result.append(mvr)
        mvr += datetime.timedelta(days=1)
    if to_ < from_:
        result = result[::-1]
    return result


# ECHO_OP_ID = "a0603967-154d-4201-a5f2-fb835ac19a5d"
# SVN_EXPORT_OP_ID = "7306fbe8-3ae7-4eb0-b846-e132649b9033"
# UPSERT_OP_ID = "f5f6a584-339c-493e-8b72-0774d19a46e5"
# UGC_CONFIG_PATH = "arcadia/analytics/videolog/strm-stats/ugc_ch/ugc_config.json"
# NIRVANA_TO_CLICKHOUSE_PATH = "arcadia/analytics/videolog/strm-stats/ugc_ch/ugc_nirvana_to_clickhouse.py"
OP_ID = "00d85616-9852-4607-bfd7-888ea2bc0bd8"


def process_date(date_from, date_to):
    with vh.Graph() as graph:

        vh.op(id=OP_ID)(
            _options={
                "list_of_paths": list_of_paths,
                "job-command": JOB_COMMAND.replace(
                    "@[date_from]", str(min(date_from, date_to))
                ).replace("@[date_to]", str(max(date_from, date_to))),
                "ttl": 1440,
            }
        )

        vh.run(
            graph,
            oauth_token=os.environ["NIRVANA_TOKEN"],
            workflow_guid="b06b9889-0227-4e36-a968-b668fc464b59",
            wait=True,
            description="cube external {}-{}".format(
                min(date_from, date_to), max(date_from, date_to)
            ),
            quota="mm-metrics",
            keep_going=True,
            api_retry_delay=60,
            api_retries=-1,
        )


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--from")
    parser.add_argument("--to")
    args = parser.parse_args()

    from_ = getattr(args, "from")
    to_ = getattr(args, "to")
    all_dates = date_range(from_, to_)
    reversed_ = all_dates[::-1]
    packs = []
    N = 7
    while reversed_:
        packs.append(reversed_[:N])
        reversed_ = reversed_[N:]
    for pack in packs:
        print("processing {}-{}".format(min(pack), max(pack)))
        process_date(min(pack), max(pack))


if __name__ == "__main__":
    main()
