#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import datetime
from yql.api.v1.client import YqlClient
from videolog_common import (
    apply_replacements,
    YqlRunner,
)

TITLE = "[MMA-4930] Index Dups | YQL"


def main():
    proxy = os.environ["YT_PROXY"]
    yc = YqlClient(db=proxy.lower(), token=os.environ["YQL_TOKEN"])
    yr = YqlRunner(client=yc, title=TITLE)
    with open("mma_4930_index_dups.sql", "rb") as f:
        query = f.read().decode("utf8")
    now = datetime.datetime.now()
    current_ts = now.strftime("%s")
    date = str(now.date())
    query = apply_replacements(
        query,
        {
            "@[current_ts]": str(current_ts),
            "@[date]": str(date)
        },
    )
    yr.run(
        query,
        wait=True,
    )


if __name__ == "__main__":
    main()
