use hahn;

$roundHour = ($x) -> {
    RETURN CAST($x - ($x % 3600) as UInt64)
};

DEFINE SUBQUERY $join_cell_lac_data($sessions_input, $cell_lac_data_input) AS

$cell_lac_data = (
    select
        yandexuid,
        round_hour,
        ListSort(AGGREGATE_LIST(
            RemoveMember(RemoveMember(TableRow(), "fielddate_tsmax"), "yandexuid")
        ), ($x) -> {RETURN $x.ts_max}) as cell_lac_data
    from $cell_lac_data_input()
    group by yandexuid, round_hour
    having count(*) <= 60
);

$sessions = (
    select
        *
    from $sessions_input() as s
);

$chooseCellLacInternal = ($right_one, $timestamp) -> {
    RETURN AsStruct(
        $right_one.CellID as CellID,
        $right_one.Lac as Lac,
        $right_one.ts_min as cell_lac_ts_min,
        $right_one.ts_max as cell_lac_ts_max,
        MIN_OF(ABS($right_one.ts_min - $timestamp), ABS($right_one.ts_max - $timestamp)) as ts_distance
    )
};

$chooseCellLac = ($cell_lac_data, $timestamp) -> {
    $filtered = ListSort(
        $cell_lac_data, ($x) -> {RETURN MIN_OF(ABS($x.ts_min - $timestamp), ABS($x.ts_max - $timestamp))}
    );
    RETURN IF(
        ListLength($filtered) > 0,
        $chooseCellLacInternal(unwrap(ListReverse($filtered)[0]), $timestamp),
        NULL
    )
};

$struct_type = Struct<
'CellID':Int64?,'Lac':Int64?,'round_hour':Uint64?,
'ts_max':Uint64?,'ts_min':Uint64?
>;

$joined = (
    select
        s.*,
        l.cell_lac_data as cell_lac_data_round_hour,
        l1.cell_lac_data as cell_lac_data_round_hour_prev,
        l2.cell_lac_data as cell_lac_data_round_hour_next,
        ListUnionAll(
            l1.cell_lac_data ?? ListCreate($struct_type),
            l.cell_lac_data ?? ListCreate($struct_type),
            l2.cell_lac_data ?? ListCreate($struct_type)
        ) as cell_lac_data
    from $sessions as s
    left join $cell_lac_data as l on (s.yandexuid == l.yandexuid and s.round_hour == l.round_hour)
    left join $cell_lac_data as l1 on (s.yandexuid == l1.yandexuid and s.round_hour_prev == l1.round_hour)
    left join $cell_lac_data as l2 on (s.yandexuid == l2.yandexuid and s.round_hour_next == l2.round_hour)
);

$joined_p2 = (
    select
        s.*,
        $chooseCellLac(cell_lac_data, `timestamp`).CellID as CellID,
        $chooseCellLac(cell_lac_data, `timestamp`).Lac as Lac,
        $chooseCellLac(cell_lac_data, `timestamp`).cell_lac_ts_min as cell_lac_ts_min,
        $chooseCellLac(cell_lac_data, `timestamp`).cell_lac_ts_max as cell_lac_ts_max,
        $chooseCellLac(cell_lac_data, `timestamp`).ts_distance as cell_lac_ts_distance,
        ListLength(ListUniq(
            ListMap(cell_lac_data, ($x) -> {RETURN $x.CellID})
        )) as cell_id_uniq,
        ListLength(ListUniq(
            ListMap(cell_lac_data, ($x) -> {RETURN $x.Lac})
        )) as lac_uniq,
        ABS(CAST(`timestamp` as Int64) - cast($chooseCellLac(cell_lac_data, `timestamp`).cell_lac_ts_min as Int64)) as cell_lac_tsmin_diff,
        ABS(CAST(`timestamp` as Int64) - cast($chooseCellLac(cell_lac_data, `timestamp`).cell_lac_ts_max as Int64)) as cell_lac_tsmax_diff,
        MIN_OF(
            ABS(CAST(`timestamp` as Int64) - cast($chooseCellLac(cell_lac_data, `timestamp`).cell_lac_ts_min as Int64)),
            ABS(CAST(`timestamp` as Int64) - cast($chooseCellLac(cell_lac_data, `timestamp`).cell_lac_ts_max as Int64))
        ) as cell_lac_timestamp_diff
    from $joined as s
);

select * from $joined_p2;
END DEFINE;

export $join_cell_lac_data;