import datetime
from yt import yson


def process_value(value):
    if isinstance(value, bytes):
        return value.decode("utf8", errors="replace")
    if isinstance(value, (dict, list)):
        return yson.dumps(value)
    return value


def get_round_hour(ts):
    return ts - (ts % 3600)


def make_record_1(key, ts_min, ts_max, cell_id, lac, round_hour, cmo):
    return {
        "yandexuid": process_value(key),
        "CellID": cell_id,
        "Lac": lac,
        "ts_min": ts_min,
        "ts_max": ts_max,
        "ConnectedMobileOperator": cmo,
        "round_hour": round_hour,
        "fielddate_tsmax": str(
            datetime.datetime.fromtimestamp(int(ts_max)).date()
        ),
    }


def reducer(key, recs):
    ts_min = None
    ts_max = None
    cell_id = None
    lac = None
    cmo = None
    prev_round_hour = None
    for rec in recs:
        cmo = rec.ConnectedMobileOperator
        if not ts_min:
            ts_min = rec.timestamp
        if not cell_id:
            cell_id = rec.CellID
        if not lac:
            lac = rec.Lac
        round_hour = get_round_hour(rec.timestamp)
        if not prev_round_hour:
            prev_round_hour = round_hour
        if (
            rec.CellID == cell_id
            and rec.Lac == lac
            and round_hour == prev_round_hour
        ):
            ts_max = rec.timestamp
        else:
            if not ts_max:
                ts_max = ts_min
            try:
                rec_ = make_record_1(
                    key, ts_min, ts_max, cell_id, lac, prev_round_hour, cmo
                )
                yield rec_
            except ValueError:
                pass
            cell_id = rec.CellID
            lac = rec.Lac
            ts_min = rec.timestamp
            ts_max = rec.timestamp
        prev_round_hour = round_hour
    if not ts_max:
        ts_max = ts_min
    try:
        rec_ = make_record_1(
            key, ts_min, ts_max, cell_id, lac, round_hour, cmo
        )
        yield rec_
    except ValueError:
        pass
