use hahn;
pragma yt.Pool = "@[pool]";
pragma yt.PoolTrees = "physical";
pragma yt.UseDefaultTentativePoolTrees;

$output_table = "@[output_table]";
$input_table = "@[input_table]";

$getOperator = ($provider) -> {
    return case
    when $provider == "beeline" or $provider == "vimpelcom" then "beeline"
    when $provider == "tele2 russia" or $provider == "t2 mobile llc" then "tele2"
    when $provider == "pjsc megafon" then "megafon"
    when $provider == "mts pjsc" then "mts"
    else null
    end
};

insert into $output_table with truncate
select
    "@[grouping_field]" as grouping_level,
    @[grouping_field] as grouping_value,
    operator,
    some(Geo::RoundRegionByLocation(lat, lon, "region").name) as region,
    some(city) as city,
    CountDistinctEstimate(yandexuid) as users,
    sum(bytes_sent) / Math::Pow(1024, 3) as traffic_gbytes,
    COUNT(*) as `views`,
    avg(first_bufferization_kbit_sec) as first_bufferization_kbit_sec,
    sum(refuse) / cast(count(*) as Double) as refuse_share,
    sum(total_buffer_count) / (sum(view_time) / 60.0) as bufferizations_per_min,
    sum(total_buffer_duration) / (sum(view_time) / 60.0) as bufferizations_duration_per_min,
    sum(total_buffer_count) / cast(count(*) as double) as bufferizations_per_view,
    sum(total_buffer_duration) / cast(count(*) as double) as bufferizations_duration_per_view,
    avg(kbit_sec) as kbit_sec,
    median(kbit_sec) as kbit_sec_median,
    avg(first_buffer_duration) as avg_first_buffer_duration,
    (
        cast(
            ((sum(res144) ?? 0) * 144.0
            + (sum(res240) ?? 0) * 240.0
            + (sum(res360) ?? 0) * 360.0
            + (sum(res480) ?? 0) * 480.0
            + (sum(res720) ?? 0) * 720.0
            + (sum(res1080) ?? 0) * 1080.0)
            as Double
        )
        / cast(
            (sum(res144 ?? 0) + (sum(res240) ?? 0) + (sum(res360) ?? 0) + (sum(res480) ?? 0) + (sum(res720) ?? 0) + (sum(res1080) ?? 0))
            as Double
        )
    ) as avg_resolution,
    (sum(res144) ?? 0) / cast((sum(res144 ?? 0) + (sum(res240) ?? 0) + (sum(res360) ?? 0) + (sum(res480) ?? 0) + (sum(res720) ?? 0) + (sum(res1080) ?? 0)) as Double) as res144_share,
    (sum(res240) ?? 0) / cast((sum(res144 ?? 0) + (sum(res240) ?? 0) + (sum(res360) ?? 0) + (sum(res480) ?? 0) + (sum(res720) ?? 0) + (sum(res1080) ?? 0)) as Double) as res240_share,
    (sum(res360) ?? 0) / cast((sum(res144 ?? 0) + (sum(res240) ?? 0) + (sum(res360) ?? 0) + (sum(res480) ?? 0) + (sum(res720) ?? 0) + (sum(res1080) ?? 0)) as Double) as res360_share,
    (sum(res480) ?? 0) / cast((sum(res144 ?? 0) + (sum(res240) ?? 0) + (sum(res360) ?? 0) + (sum(res480) ?? 0) + (sum(res720) ?? 0) + (sum(res1080) ?? 0)) as Double) as res480_share,
    (sum(res720) ?? 0) / cast((sum(res144 ?? 0) + (sum(res240) ?? 0) + (sum(res360) ?? 0) + (sum(res480) ?? 0) + (sum(res720) ?? 0) + (sum(res1080) ?? 0)) as Double) as res720_share,
    (sum(res1080) ?? 0) / cast((sum(res144 ?? 0) + (sum(res240) ?? 0) + (sum(res360) ?? 0) + (sum(res480) ?? 0) + (sum(res720) ?? 0) + (sum(res1080) ?? 0)) as Double) as res1080_share,
    count_if(kbit_sec < 100) / cast(count(*) as Double) as kbit_sec_less_than_100_share,
    count_if(kbit_sec < 200) / cast(count(*) as Double) as kbit_sec_less_than_200_share,
    count_if(kbit_sec < 300) / cast(count(*) as Double) as kbit_sec_less_than_300_share,
    count_if(kbit_sec < 400) / cast(count(*) as Double) as kbit_sec_less_than_400_share,
    count_if(kbit_sec < 500) / cast(count(*) as Double) as kbit_sec_less_than_500_share,
    count_if(kbit_sec < 600) / cast(count(*) as Double) as kbit_sec_less_than_600_share,
    count_if(kbit_sec < 700) / cast(count(*) as Double) as kbit_sec_less_than_700_share,
    count_if(kbit_sec < 800) / cast(count(*) as Double) as kbit_sec_less_than_800_share,
    count_if(kbit_sec < 900) / cast(count(*) as Double) as kbit_sec_less_than_900_share,
    count_if(kbit_sec < 1000) / cast(count(*) as Double) as kbit_sec_less_than_1000_share,
    count_if(kbit_sec < 1100) / cast(count(*) as Double) as kbit_sec_less_than_1100_share,
    count_if(kbit_sec < 1200) / cast(count(*) as Double) as kbit_sec_less_than_1200_share,
    count_if(kbit_sec < 1300) / cast(count(*) as Double) as kbit_sec_less_than_1300_share,
    count_if(kbit_sec < 1400) / cast(count(*) as Double) as kbit_sec_less_than_1400_share,
    count_if(kbit_sec < 1500) / cast(count(*) as Double) as kbit_sec_less_than_1500_share,
    count_if(kbit_sec < 1600) / cast(count(*) as Double) as kbit_sec_less_than_1600_share,
    count_if(kbit_sec < 1700) / cast(count(*) as Double) as kbit_sec_less_than_1700_share,
    count_if(kbit_sec < 1800) / cast(count(*) as Double) as kbit_sec_less_than_1800_share,
    count_if(kbit_sec < 1900) / cast(count(*) as Double) as kbit_sec_less_than_1900_share,
    count_if(kbit_sec < 2000) / cast(count(*) as Double) as kbit_sec_less_than_2000_share,
    count_if(kbit_sec < 2100) / cast(count(*) as Double) as kbit_sec_less_than_2100_share,
    count_if(kbit_sec < 2200) / cast(count(*) as Double) as kbit_sec_less_than_2200_share,
    count_if(kbit_sec < 2300) / cast(count(*) as Double) as kbit_sec_less_than_2300_share,
    count_if(kbit_sec < 2400) / cast(count(*) as Double) as kbit_sec_less_than_2400_share,
    count_if(kbit_sec < 2500) / cast(count(*) as Double) as kbit_sec_less_than_2500_share,
    count_if(kbit_sec < 2600) / cast(count(*) as Double) as kbit_sec_less_than_2600_share,
    count_if(kbit_sec < 2700) / cast(count(*) as Double) as kbit_sec_less_than_2700_share,
    count_if(kbit_sec < 2800) / cast(count(*) as Double) as kbit_sec_less_than_2800_share,
    count_if(kbit_sec < 2900) / cast(count(*) as Double) as kbit_sec_less_than_2900_share,
    count_if(kbit_sec < 3000) / cast(count(*) as Double) as kbit_sec_less_than_3000_share,
    count_if(kbit_sec < 3100) / cast(count(*) as Double) as kbit_sec_less_than_3100_share,
    count_if(kbit_sec < 3200) / cast(count(*) as Double) as kbit_sec_less_than_3200_share,
    count_if(kbit_sec < 3300) / cast(count(*) as Double) as kbit_sec_less_than_3300_share,
    count_if(kbit_sec < 3400) / cast(count(*) as Double) as kbit_sec_less_than_3400_share,
    count_if(kbit_sec < 3500) / cast(count(*) as Double) as kbit_sec_less_than_3500_share,
    count_if(kbit_sec < 3600) / cast(count(*) as Double) as kbit_sec_less_than_3600_share,
    count_if(kbit_sec < 3700) / cast(count(*) as Double) as kbit_sec_less_than_3700_share,
    count_if(kbit_sec < 3800) / cast(count(*) as Double) as kbit_sec_less_than_3800_share,
    count_if(kbit_sec < 3900) / cast(count(*) as Double) as kbit_sec_less_than_3900_share,
    count_if(kbit_sec < 4000) / cast(count(*) as Double) as kbit_sec_less_than_4000_share,
    count_if(kbit_sec < 4100) / cast(count(*) as Double) as kbit_sec_less_than_4100_share,
    count_if(kbit_sec < 4200) / cast(count(*) as Double) as kbit_sec_less_than_4200_share,
    count_if(kbit_sec < 4300) / cast(count(*) as Double) as kbit_sec_less_than_4300_share,
    count_if(kbit_sec < 4400) / cast(count(*) as Double) as kbit_sec_less_than_4400_share,
    count_if(kbit_sec < 4500) / cast(count(*) as Double) as kbit_sec_less_than_4500_share,
    count_if(kbit_sec < 4600) / cast(count(*) as Double) as kbit_sec_less_than_4600_share,
    count_if(kbit_sec < 4700) / cast(count(*) as Double) as kbit_sec_less_than_4700_share,
    count_if(kbit_sec < 4800) / cast(count(*) as Double) as kbit_sec_less_than_4800_share,
    count_if(kbit_sec < 4900) / cast(count(*) as Double) as kbit_sec_less_than_4900_share,
    count_if(kbit_sec < 5000) / cast(count(*) as Double) as kbit_sec_less_than_5000_share
from $input_table
@[custom_condition]
group by @[grouping_field], $getOperator(isp) as operator
@[having];