use hahn;

$roundHour = ($x) -> {
    RETURN CAST($x - ($x % 3600) as UInt64)
};
-- location is rounded to nearest hour to prevent giant joins

DEFINE SUBQUERY $join_location_data($sessions_input, $location_data_input) AS

$location_data = (
    select
        yandexuid,
        round_hour,
        ListSort(AGGREGATE_LIST(
            RemoveMember(RemoveMember(TableRow(), "fielddate_tsmax"), "yandexuid")
        ), ($x) -> {RETURN $x.ts_max}) as location_data
    from $location_data_input()
    group by yandexuid, round_hour
    having count(*) <= 60
);

$sessions = (
    select
        s.*, $roundHour(CAST(`timestamp` as UInt64)) as round_hour,
        $roundHour(CAST(`timestamp` as UInt64)) - 3600 as round_hour_prev,
        $roundHour(CAST(`timestamp` as UInt64)) + 3600 as round_hour_next
    from $sessions_input() as s
);

$chooseLocationInternal = ($right_one, $timestamp) -> {
    $city = Geo::RoundRegionByLocation($right_one.lat, $right_one.lon, "city").name;
    RETURN AsStruct(
        $right_one.lat as lat,
        $right_one.lon as lon,
        Geo::RegionByLocation($right_one.lat, $right_one.lon) as latlon_region,
        $city as city,
        $right_one.s2_p15 as s2_p15,
        $right_one.s2_p14 as s2_p14,
        $right_one.s2_p13 as s2_p13,
        $right_one.ts_min as location_ts_min,
        $right_one.ts_max as location_ts_max,
        MIN_OF(ABS($right_one.ts_min - $timestamp), ABS($right_one.ts_max - $timestamp)) as ts_distance
    )
};

$chooseLocation = ($location_data, $timestamp) -> {
    $filtered = ListSort(
        $location_data, ($x) -> {RETURN MIN_OF(ABS($x.ts_min - $timestamp), ABS($x.ts_max - $timestamp))}
    );
    RETURN IF(
        ListLength($filtered) > 0,
        $chooseLocationInternal(unwrap(ListReverse($filtered)[0]), $timestamp),
        NULL
    )
};

$struct_type = Struct<
'lat':Double?,'lon':Double?,'round_hour':Uint64?,
's2_p13':Uint64?,'s2_p14':Uint64?,'s2_p15':Uint64?,
'ts_max':Uint64?,'ts_min':Uint64?
>;

$joined = (
    select
        s.*,
        l.location_data as location_data_round_hour,
        l1.location_data as location_data_round_hour_prev,
        l2.location_data as location_data_round_hour_next,
        ListUnionAll(
            l1.location_data ?? ListCreate($struct_type),
            l.location_data ?? ListCreate($struct_type),
            l2.location_data ?? ListCreate($struct_type)
        ) as location_data
    from $sessions as s
    left join $location_data as l on (s.yandexuid == l.yandexuid and s.round_hour == l.round_hour)
    left join $location_data as l1 on (s.yandexuid == l1.yandexuid and s.round_hour_prev == l1.round_hour)
    left join $location_data as l2 on (s.yandexuid == l2.yandexuid and s.round_hour_next == l2.round_hour)
);

$joined_p2 = (
    select
        s.*,
        $chooseLocation(location_data, `timestamp`).lat as lat,
        $chooseLocation(location_data, `timestamp`).lon as lon,
        $chooseLocation(location_data, `timestamp`).latlon_region as latlon_region,
        $chooseLocation(location_data, `timestamp`).city as city,
        $chooseLocation(location_data, `timestamp`).s2_p15 as s2_p15,
        $chooseLocation(location_data, `timestamp`).s2_p14 as s2_p14,
        $chooseLocation(location_data, `timestamp`).s2_p13 as s2_p13,
        $chooseLocation(location_data, `timestamp`).location_ts_min as location_ts_min,
        $chooseLocation(location_data, `timestamp`).location_ts_max as location_ts_max,
        $chooseLocation(location_data, `timestamp`).ts_distance as ts_distance,
        ListLength(ListUniq(
            ListMap(location_data, ($x) -> {RETURN $x.s2_p13})
        )) as s2_p13_uniq,
        ListLength(ListUniq(
            ListMap(location_data, ($x) -> {RETURN $x.s2_p14})
        )) as s2_p14_uniq,
        ListLength(ListUniq(
            ListMap(location_data, ($x) -> {RETURN $x.s2_p15})
        )) as s2_p15_uniq,
        ABS(CAST(`timestamp` as Int64) - cast($chooseLocation(location_data, `timestamp`).location_ts_min as Int64)) as location_tsmin_diff,
        ABS(CAST(`timestamp` as Int64) - cast($chooseLocation(location_data, `timestamp`).location_ts_max as Int64)) as location_tsmax_diff,
        MIN_OF(
            ABS(CAST(`timestamp` as Int64) - cast($chooseLocation(location_data, `timestamp`).location_ts_min as Int64)),
            ABS(CAST(`timestamp` as Int64) - cast($chooseLocation(location_data, `timestamp`).location_ts_max as Int64))
        ) as location_timestamp_diff
    from $joined as s
);

select * from $joined_p2;
END DEFINE;

export $join_location_data;