use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
pragma yt.ParallelOperationsLimit = "4";
pragma yt.Pool = "@[pool]";
pragma yt.PoolTrees = "physical";
pragma yt.UseDefaultTentativePoolTrees;
pragma library("location_data_processed.sql");
pragma library("location_join.sql");
pragma library("cell_lac_data.sql");
pragma library("cell_lac_join.sql");
pragma library("perf_data.sql");
pragma library("perf_join.sql");
pragma library("technology_join.sql");
IMPORT location_data_processed SYMBOLS $get_location_data, $get_technology_data;
IMPORT location_join SYMBOLS $join_location_data;
IMPORT perf_data SYMBOLS $get_perf_data;
IMPORT perf_join  SYMBOLS $join_perf_data;
IMPORT cell_lac_data SYMBOLS $get_cell_lac_data;
IMPORT cell_lac_join SYMBOLS $join_cell_lac_data;
IMPORT technology_join SYMBOLS $join_technology_data;

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$output_table = "@[output_table]";

$stalled = ($errors) -> {
    $errors = Yson::ConvertToList($errors);
    $init = ListFilter($errors, ($x) -> {RETURN Yson::LookupString($x, "id") == "Stalled_Init"});
    $rel_time = IF(ListLength($init) > 0, Yson::LookupUint64(unwrap($init[0]), "rel_time"), NULL);
    $init = ListReverse(ListTake($init, 3))[0];
    $first_stalled_duration = Yson::ConvertToInt64(Yson::YPath($init, "/details/stalledDuration")) ?? 0;
    $all_stalleds = ListFlatMap($errors, ($x) -> {
        RETURN IF(
            Yson::LookupString($x, "id_raw") == "Stalled",
            Yson::ConvertToInt64(Yson::YPath($x, "/details/stalledDuration")) ?? 0,
            NULL
        )
    });
    RETURN AsStruct(
        $first_stalled_duration as first_buffer_duration,
        ListLength($all_stalleds) as total_buffer_count,
        ListSum($all_stalleds) as total_buffer_duration,
        $rel_time as first_buffer_rel_time
    )
};

$sourcesAggrCheck = ($sources_aggr) -> {
    RETURN FIND($sources_aggr, "chunk") IS NOT NULL AND (
        FIND($sources_aggr, "start") IS NOT NULL
        OR FIND($sources_aggr, "heartbeat") IS NOT NULL
    )
};


define subquery $sessions() as
    select
        vsid,
        `timestamp`,
        video_content_id,
        channel_old,
        channel,
        program,
        add_info,
        bytes_sent,
        errors,
        ip,
        device_id,
        view_time,
        price,
        os_family,
        browser_name,
        browser_version,
        ref_from,
        ref_from_block,
        stream_block,
        region,
        is_kal,
        view_type,
        yandexuid,
        yu_hash,
        $stalled(errors).first_buffer_duration as first_buffer_duration,
        $stalled(errors).total_buffer_count as total_buffer_count,
        $stalled(errors).total_buffer_duration as total_buffer_duration,
        $stalled(errors).first_buffer_rel_time as first_buffer_rel_time,
        (sources_aggr ?? Yson::LookupString(add_info, "sources_aggr")) as sources_aggr
    from range(
        `cubes/video-strm`, $date_from, $date_to, `sessions`
    ) with columns Struct<sources_aggr:String?,is_kal:String?,device_id:String?> as s
    where $sourcesAggrCheck(sources_aggr ?? Yson::LookupString(add_info, "sources_aggr"))
    and os_family in ("iOS", "Android")
    and country == "RU";
end define;

define subquery $location_data() as 
    select * from $get_location_data($date_from, $date_to, $sessions);
end define;

define subquery $cell_lac_data() as
    select * from $get_cell_lac_data($date_from, $date_to, $sessions);
end define;

define subquery $perf_data() as
    select * from $get_perf_data($date_from, $date_to);
end define;

define subquery $joined_with_location() as 
    select * from $join_location_data($sessions, $location_data);
end define;

define subquery $joined_with_cell_lac() as
    select * from $join_cell_lac_data($joined_with_location, $cell_lac_data);
end define;

-- $sessions_source_table = $output_table || "_sessions_source";
-- insert into $sessions_source_table with truncate
-- select * from $sessions();

-- $location_table = $output_table || "_location";
-- insert into $location_table with truncate
-- select * from $location_data();

-- $perf_table = $output_table || "_perf";
-- insert into $perf_table with truncate
-- select * from $perf_data();

-- $location_non_joined_table = $output_table || "_non_joined";
-- insert into $location_non_joined_table with truncate
-- select * from $joined_with_location() where location_data is null or ListLength(location_data) == 0;

define subquery $technology_data() as
    select * from $get_technology_data($date_from, $date_to, $sessions);
end define;

define subquery $joined_with_technology() as
    select * from $join_technology_data($joined_with_cell_lac, $technology_data);
end define;

$joined_with_perf = select * from $join_perf_data($perf_data, $joined_with_technology);

$enriched = (
    select
        s.*,
        IF(
            sources_aggr like '%start%'
            and not (sources_aggr like '%heartbeat%'),
            1,
            0
        ) as refuse,
        Geo::GetIspNameByIp(ip) as isp,
        throughput_first_buffer as first_bufferization_kbit_sec,
        throughput as kbit_sec,
        Yson::ConvertToInt64(Yson::YPath(add_info, "/resolutions/144")) as res144,
        Yson::ConvertToInt64(Yson::YPath(add_info, "/resolutions/240")) as res240,
        Yson::ConvertToInt64(Yson::YPath(add_info, "/resolutions/360")) as res360,
        Yson::ConvertToInt64(Yson::YPath(add_info, "/resolutions/480")) as res480,
        Yson::ConvertToInt64(Yson::YPath(add_info, "/resolutions/720")) as res720,
        Yson::ConvertToInt64(Yson::YPath(add_info, "/resolutions/1080")) as res1080,
    from $joined_with_perf as s
);

insert into $output_table with truncate
select * from $enriched;
