import json

root_month = "//home/videoquality/vh_analytics/mma-3568-tele2/2019-09-01_2019-09-30"
root_week = "//home/videoquality/vh_analytics/mma-3568-tele2/old/2019-10-14_2019-10-20"

bash = []

for timeframe in ["month", "week"]:
    for precision in ["25", "50"]:
        for region in ["moscow_vao", "tatar", "spb_lenoblast"]:
            root = root_month if timeframe == "month" else root_week
            base_table_name = "{root}/megafon_{region}_{precision}{month}_s2_p".format(
                root=root, region=region, precision=precision,
                month="_month" if timeframe == "month" else "_week"
            )
            filename = "megafon_{}_{}_{}.json".format(region, timeframe, precision)
            obj = {
                "input": [
                    "{}{}".format(base_table_name, x) for x in (13, 14, 15)
                ]
            }
            with open(filename, "w") as f:
                f.write(json.dumps(obj, indent=4))
            bash.append("python ../kmz_gen.py -c {}".format(filename))

with open("megafon.sh", "w") as f:
    f.write(";\n".join(bash) + "\n")

