from collections import defaultdict, Counter


def safediv(x, y):
    try:
        return x / y
    except ZeroDivisionError:
        return 0


def reducer(key, recs):
    ts_lists = None
    data = defaultdict(Counter)
    for rec in recs:
        if not ts_lists and rec.ts_lists:
            ts_lists = rec.ts_lists
        if not ts_lists:
            continue
        for ts_list in filter(
            lambda x: x[0] <= rec.timestamp <= x[1], ts_lists
        ):
            duration = rec.duration or 0
            transferSize = rec.transferSize or 0
            data[ts_list]["transferSize"] += transferSize  # bytes
            data[ts_list]["duration"] += duration  # milliseconds
            if ts_list[2] and rec.timestamp <= ts_list[2]:
                data[ts_list]["transferSize_first_buffer"] += transferSize
                data[ts_list]["duration_first_buffer"] += duration
    for ts_list in data:
        result = data[ts_list]
        result["throughput"] = (
            safediv(result["transferSize"], result["duration"])
            * 8  # 8 (bytes -> bits) * 1000 (milliseconds -> seconds) / 1000 (bits -> kbits)
        )
        if result.get("transferSize_first_buffer"):
            result["throughput_first_buffer"] = (
                safediv(
                    result["transferSize_first_buffer"],
                    result["duration_first_buffer"],
                )
                * 8
            )
        result = dict(result)
        result["vsid"] = key
        result["timestamp"] = ts_list[0]
        yield result
