use hahn;

$roundHour = ($x) -> {
    RETURN CAST($x - ($x % 3600) as UInt64)
};

DEFINE SUBQUERY $join_technology_data($sessions_input, $technology_data_input) AS

$technology_data = (
    select
        yandexuid,
        round_hour,
        ListSort(AGGREGATE_LIST(
            RemoveMember(RemoveMember(TableRow(), "fielddate_tsmax"), "yandexuid")
        ), ($x) -> {RETURN $x.ts_max}) as technology_data
    from $technology_data_input()
    group by yandexuid, round_hour
    having count(*) <= 60
);

$sessions = (
    select
        *
    from $sessions_input() as s
);

$chooseTechnologyInternal = ($right_one, $timestamp) -> {
    RETURN AsStruct(
        $right_one.technology as technology,
        $right_one.ts_min as technology_ts_min,
        $right_one.ts_max as technology_ts_max,
        MIN_OF(ABS($right_one.ts_min - $timestamp), ABS($right_one.ts_max - $timestamp)) as ts_distance
    )
};

$chooseTechnology = ($technology_data, $timestamp) -> {
    $filtered = ListSort(
        $technology_data, ($x) -> {RETURN MIN_OF(ABS($x.ts_min - $timestamp), ABS($x.ts_max - $timestamp))}
    );
    RETURN IF(
        ListLength($filtered) > 0,
        $chooseTechnologyInternal(unwrap(ListReverse($filtered)[0]), $timestamp),
        NULL
    )
};

$struct_type = Struct<
'round_hour':UInt64?,
'technology':String?,
'ts_min':UInt64?,
'ts_max':UInt64?,
>;

$joined = (
    select
        s.*,
        l.technology_data as technology_data_round_hour,
        l1.technology_data as technology_data_round_hour_prev,
        l2.technology_data as technology_data_round_hour_next,
        ListUnionAll(
            l1.technology_data ?? ListCreate($struct_type),
            l.technology_data ?? ListCreate($struct_type),
            l2.technology_data ?? ListCreate($struct_type)
        ) as technology_data
    from $sessions as s
    left join $technology_data as l on (s.yandexuid == l.yandexuid and s.round_hour == l.round_hour)
    left join $technology_data as l1 on (s.yandexuid == l1.yandexuid and s.round_hour_prev == l1.round_hour)
    left join $technology_data as l2 on (s.yandexuid == l2.yandexuid and s.round_hour_next == l2.round_hour)
);

$joined_p2 = (
    select
        s.*,
        $chooseTechnology(technology_data, `timestamp`).technology as technology,
        $chooseTechnology(technology_data, `timestamp`).technology_ts_min as technology_ts_min,
        $chooseTechnology(technology_data, `timestamp`).technology_ts_max as technology_ts_max,
        $chooseTechnology(technology_data, `timestamp`).ts_distance as technology_ts_distance,
        ListLength(ListUniq(
            ListMap(technology_data, ($x) -> {RETURN $x.technology})
        )) as technology_uniq,
        ABS(CAST(`timestamp` as Int64) - cast($chooseTechnology(technology_data, `timestamp`).technology_ts_min as Int64)) as technology_tsmin_diff,
        ABS(CAST(`timestamp` as Int64) - cast($chooseTechnology(technology_data, `timestamp`).technology_ts_max as Int64)) as technology_tsmax_diff,
        MIN_OF(
            ABS(CAST(`timestamp` as Int64) - cast($chooseTechnology(technology_data, `timestamp`).technology_ts_min as Int64)),
            ABS(CAST(`timestamp` as Int64) - cast($chooseTechnology(technology_data, `timestamp`).technology_ts_max as Int64))
        ) as technology_timestamp_diff
    from $joined as s
);

select * from $joined_p2;
END DEFINE;

export $join_technology_data;