import json

root_month = "//home/videoquality/vh_analytics/mma-3568-tele2/2019-09-01_2019-09-30"
root_week = "//home/videoquality/vh_analytics/mma-3568-tele2/old/2019-10-14_2019-10-20"

bash = []

for timeframe in ["week", "month"]:
    for precision in ["25", "50"]:
        for region in ["ekb_oblast", "perm_krai", "moscow_southwest"]:
            root = root_month if timeframe == "month" else root_week
            if timeframe == "week":
                if precision == "25":
                    precision_ = "_25"
                else:
                    precision_ = ""
            else:
                precision_ = "_{}".format(precision)
            base_table_name = "{root}/{region}{month}{precision}_s2_p".format(
                root=root, region=region, precision=precision_,
                month="_09" if timeframe == "month" else ""
            )
            filename = "tele2_{}_{}_{}.json".format(region, timeframe, precision)
            obj = {
                "input": [
                    "{}{}".format(base_table_name, x) for x in (13, 14, 15)
                ]
            }
            with open(filename, "w") as f:
                f.write(json.dumps(obj, indent=4))
            bash.append("python ../kmz_gen_fk.py -c {}".format(filename))

with open("tele2.sh", "w") as f:
    f.write(";\n".join(bash) + "\n")

