# Данные для мобильных операторов

Проект по обработке данных аппметрики и логов видеосмотрения для получения данных, полезных для мобильных операторов, с последующими обменом / продажей этих данных.

Операторов интересуют данные по видеосмотрению (скорость интернета, количество буферизаций, скорость во время буферизаций и т.д.), а также данные по радиопокрытию (сила сигнала и другие метрики в LTE / 3G / 2G). Всё это накладывается на карту при помощи [s2geometry](https://s2geometry.io/) в имплементации [s2sphere](https://github.com/sidewalklabs/s2sphere).

## Пайплайн обработки данных

Берётся диапазон дат (сейчас в основном — месяц), запускается мап, фильтрующий логи и забирающий все релевантные данные. Данные из логов видеосмотрения при помощи крипты джойнятся с мобильной метрикой (яндексуид связывается с mm_device_id). Таким образом становится возможным связать сессию видеосмотрения и геолокацию / технологию интернета / CellID.

Полученные таким образом данные группируются по геолокации или CellID, фильтруются и из получившихся таблиц строятся готовые выгрузки для операторов. Форматы — csv и kmz.

## Детали

### Первый этап — мап+редьюс сырых логов

Пример запуска:

`python runner_v2.py --pool pecheny --from 2020-02-01 --to 2020-02-29`

Эта строчка запускает мап+редьюс, который строит большую (≈4тб) табличку с данными за месяц. [Пример получившейся таблички](//home/videoquality/vh_analytics/mma-3568-tele2/new_algo_test/2020-02-01_2020-02-29/reduced1). В этой табличке уже сджойненные данные (яндексуид + метричный device_id + геолокация + технология интернета ...). Из неё можно делать выгрузки по конкретному региону, с нужными фильтрами и группировками.

### Второй этап — группировки + подселекты

Данные из таблички, полученные на первом этапе, нужно сгруппировать и отфильтровать. Сейчас есть три типа группировок:

- по оператору, технологии мобильного интернета (4g/wcdma/..) геолокации (клетке s2). В этой выгрузке метрики про видеосмотрение, полный список в [metrics.md](https://a.yandex-team.ru/arc/trunk/arcadia/analytics/videolog/strm-stats/operators_data/v2/metrics.md). [Пример](https://yql.yandex-team.ru/Operations/XmilRmHljoub4PBvaRX0YJO5694O3yUob7x7zYtTpeM=)
- по оператору, технологии мобильной сети (LTE/3G/2G), клетке s2. Метрики — среднее и квантили силы радиосигнала. [Пример](https://yql.yandex-team.ru/Operations/XmisOlPzVA-yjf1tCRKvtcD0zjYPmJhUyQU9vHqg8S0=)
- по оператору, Lac, CellID (идентификаторам мобильной соты), технологии мобильного интернета. Нужно для внутренней диагностики, тут мы отдаём каждому оператору данные только по его собственной сети, не по конкурентам. В этой выгрузке метрики про видеосмотрение (теоретически ничто не мешает и силу сигнала посмотреть, но пока не просили) [Пример](https://yql.yandex-team.ru/Operations/XmilsGHljoub4PDjMHY4ZlfgR7L6B-mdKJo10tj0ZbE=)

После этого из этих выгрузок делаются подселекты, тк в данный момент каждому из операторов для тестирования нужен только один или несколько регионов. Плюс у нас есть ограничение — не отдаём строчки, где меньше 10 DeviceID. [Пример подселекта](https://yql.yandex-team.ru/Operations/Xmj-3p3udqJPFs8olvg8vR7uSzjD-N66Oy6rWyzhpJQ=).

### Третий этап — генерация выгрузок

Для генерации выгрузок используется скрипт `data_exporter_v2.py` плюс конфиг к нему в формате TOML. [Пример конфига](https://a.yandex-team.ru/arc/trunk/arcadia/analytics/videolog/strm-stats/operators_data/v2/kmz_gen/tomls/megafon_jan.toml). В конфиге можно указать белый / чёрный список полей из входного yson-файла (который представляет собой просто скачанную таблицу с yt), типы выгрузок (сейчас доступны csv и kmz), оператора, которому предназначается выгрузка, метрики, по которым будут строиться карты в kmz, дополнительные фильтры.

Каждому оператору мы не показываем конкурентов явно, а заменяем их плейсхолдерами operator1, operator2, operator3. Поле operator в конфиге нужно для этого.

Пример запуска:

`python data_exporter_v2.py -c data/megafon_jan/megafon_jan.toml`

— создаст csv и kmz выгрузки с соответствующими конфигу полями. Из kmz-выгрузки можно экспортировать отдельные kml-карты и показывать их в [красивом вьюере](https://st.yandex-team.ru/VIDEOUI-10643) от maximluk@.

Пример того, как выглядит такая карта: https://jing.yandex-team.ru/files/pecheny/2020-03-15T17%3A51%3A28Z.png