#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import argparse
import json
import yt.wrapper as yt
from yt.yson.yson_types import YsonEntity

columns = [
    "SignalStrength_avg",
    "SignalStrength_avg_position",
    "SignalStrength_p10",
    "SignalStrength_p10_position",
    "SignalStrength_p50",
    "SignalStrength_p50_position",
    "SignalStrength_p90",
    "SignalStrength_p90_position",
    "radio_devices",
    "radio_measurements",
]


def process_record(rec):
    base = json.loads(rec["coordinates"])
    base["data"] = {}
    good = False
    for key in columns:
        value = rec[key]
        if isinstance(value, YsonEntity):
            value = None
        if value:
            good = True
        base["data"][key] = value
    if good:
        return base


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("table")
    args = parser.parse_args()

    output = args.table.split("/")[-1] + ".json"

    result = []

    for rec in yt.read_table(args.table):
        processed = process_record(rec)
        if processed:
            result.append(processed)

    with open(output, "w") as f:
        json.dump(result, f, indent=4, sort_keys=True)


if __name__ == "__main__":
    main()
