import os

KEYS_WHITELIST = {"CellID", "Lac", "s2_value"}


def replace_extension(filepath, new_ext):
    bn, ext = os.path.splitext(filepath)
    return bn + new_ext


def filter_keys(keys, config):
    if config["included_keys"]:
        keys = [k for k in keys if k in config["included_keys"]]
    elif config["excluded_keys"]:
        keys = [k for k in keys if k not in config["excluded_keys"]]
    return keys


class Exporter:
    def __init__(self, config, config_file=None):
        self.config = config
        self.config_file = config_file
        cwd = os.getcwd()
        cfdir = os.path.dirname(config_file)
        os.chdir(cfdir)
        if self.config.get("output_folder"):
            self.wd = os.path.abspath(self.config["output_folder"])
        else:
            self.wd = os.path.abspath(os.getcwd())
        os.chdir(cwd)
