use hahn;
pragma yt.Pool = "@[pool]";
pragma yt.ParallelOperationsLimit = "4";
pragma library("helpers.sql");
import helpers symbols $get_mm_data, $get_mm_data_new;
pragma library("beeline_codegen_pivoters.sql");
import beeline_codegen_pivoters symbols $radio_by_s2_pivoter,
    $radio_by_geounit_pivoter,
    $radio_by_filial_pivoter,
    $video_by_s2_pivoter,
    $video_by_geounit_pivoter,
    $video_by_filial_pivoter,
    $radio_by_s2_month_pivoter,
    $radio_by_s2_month_binary_pivoter;

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$video_reduced_root = "@[reduced_root]";
$radio_reduced_root = $video_reduced_root || "_radio";
$output_root = "@[output_root]/@[export_name]/@[export_name]";
$geounits_table = "//home/videolog/cell_id_to_geounit_schematized_v2a";
$geounits_types_table = "//home/videolog/geounits_types";

$operator_dict = {
    "1": "mts",
    "11": "yota",
    "99": "beeline",
    "2": "megafon",
    "14": "megafon",
    "20": "tele2",
};

$fielddateFormat = DateTime::Format("%Y-%m-%d");
$getFielddate = ($ts) -> {
    $ts = CAST($ts as Uint32);
    $tm = AddTimezone(DateTime::FromSeconds($ts), "Europe/Moscow");
    RETURN $fielddateFormat($tm)
};

$processReduced = ($row) -> {
    $base = RemoveMember($row, "s2_p13");
    $base = RemoveMember($base, "s2_p14");
    $base = RemoveMember($base, "s2_p15");
    $base = RemoveMember($base, "s2_p17");
    return AsList(
        ExpandStruct(
            $base, "s2_p13" as s2_level, $row.s2_p13 as s2_value
        ),
        ExpandStruct(
            $base, "s2_p14" as s2_level, $row.s2_p14 as s2_value
        ),
        ExpandStruct(
            $base, "s2_p15" as s2_level, $row.s2_p15 as s2_value
        ),
        ExpandStruct(
            $base, "s2_p17" as s2_level, $row.s2_p17 as s2_value
        ),
    )
};

$geounits_types = (
    select geounit, filial, aggregation_type
    from $geounits_types_table
    union all
    select geounit, filial, "whole filial" as aggregation_type
    from $geounits_types_table
);


$radio_source = (
    select
        unwrap($operator_dict[OperatorID]) as operator,
        m.* without m.operator
    from range(
        $radio_reduced_root, $date_from, $date_to
    ) as m
    where DictContains($operator_dict, OperatorID)
    and $getFielddate(`timestamp`) >= $date_from
    and $getFielddate(`timestamp`) <= $date_to
);

$video_source = (
    select * from range(
        $video_reduced_root, $date_from, $date_to
    )
    where $getFielddate(`timestamp`) >= $date_from
    and $getFielddate(`timestamp`) <= $date_to
);

$video_processed = (process $video_source using $processReduced(TableRow()));
$radio_processed = (process $radio_source using $processReduced(TableRow()));

$video_with_geounits_pre = (
    select s.*, geounits as geounit
    from $video_source as s
    inner join $geounits_table as g using (s2_p13)
);
$radio_with_geounits_pre = (
    select s.*, geounits as geounit
    from $radio_source as s
    inner join $geounits_table as g using (s2_p13)
);

$video_with_geounits = (
    select
        *
    from $video_with_geounits_pre
    flatten list by geounit
);
$radio_with_geounits = (
    select
        *
    from $radio_with_geounits_pre
    flatten list by geounit
);

$video_with_filials = (
    select s.*, filial, aggregation_type
    from $video_with_geounits as s
    inner join $geounits_types as g using (geounit)
);
$radio_with_filials = (
    select s.*, filial, aggregation_type
    from $radio_with_geounits as s
    inner join $geounits_types as g using (geounit)
);

$radio_by_s2 = (
    select
        @[radio_by_s2_grouping_keys_select],
        @[radio_metrics]
    from $radio_processed
    where s2_value is not null
    and @[radio_common_conditions]
    group by @[radio_by_s2_grouping_keys]
    having @[radio_having]
);

$radio_by_s2_month = (
    select
        @[radio_by_s2_month_grouping_keys_select],
        @[radio_metrics]
    from $radio_processed
    where s2_value is not null
    and @[radio_common_conditions]
    group by @[radio_by_s2_month_grouping_keys]
    having @[radio_having]
);

$radio_by_s2_month_binary = (
    select
        @[radio_by_s2_month_binary_grouping_keys_select],
        PERCENTILE(SignalStrength, 0.5) as SignalStrength_p50
    from $radio_processed
    where s2_value is not null
    and @[radio_common_conditions]
    group by @[radio_by_s2_month_binary_grouping_keys]
);

$video_by_s2 = (
    select
        @[video_by_s2_grouping_keys_select],
        @[video_metrics]
    from $video_processed
    where s2_value is not null
    and @[video_common_conditions]
    group by @[video_by_s2_grouping_keys]
    having @[video_having]
);

$get_coordinates_raw = Python::get_coordinates_raw(
    Callable<(UInt64?)->String?>,
    FileContent("sphere_v2.py")
);

$coordinates = (
    select
        s2_value,
        some(s2_level) as s2_level,
        $get_coordinates_raw(s2_value) as coordinates
    from (
        select
            s2_value, s2_level
        from $radio_by_s2_month
        union all
        select s2_value, s2_level
        from $video_by_s2
    )
    group by s2_value
);

$radio_by_cell_lac = (
    select
        @[radio_by_cell_lac_grouping_keys_select],
        @[radio_metrics]
    from $radio_source
    where operator == "beeline"
    and @[radio_common_conditions]
    group by @[radio_by_cell_lac_grouping_keys]
    having @[radio_having]
);

$video_by_cell_lac = (
    select
        @[video_by_cell_lac_grouping_keys_select],
        @[video_metrics]
    from $video_source
    where operator == "beeline"
    and @[video_common_conditions]
    group by @[video_by_cell_lac_grouping_keys]
    having @[video_having]
);

$radio_by_geounit = (
    select
        @[radio_by_geounit_grouping_keys_select],
        @[radio_metrics]
    from $radio_with_geounits
    where @[radio_common_conditions]
    group by @[radio_by_geounit_grouping_keys]
    having @[radio_having]
);

$video_by_geounit = (
    select
        @[video_by_geounit_grouping_keys_select],
        @[video_metrics]
    from $video_with_geounits
    where @[video_common_conditions]
    group by @[video_by_geounit_grouping_keys]
    having @[video_having]
);

$radio_by_filial = (
    select
        @[radio_by_filial_grouping_keys_select],
        @[radio_metrics]
    from $radio_with_filials
    where @[radio_common_conditions]
    group by @[radio_by_filial_grouping_keys]
    having @[radio_having]
);

$video_by_filial = (
    select
        @[video_by_filial_grouping_keys_select],
        @[video_metrics]
    from $video_with_filials
    where @[video_common_conditions]
    group by @[video_by_filial_grouping_keys]
    having @[video_having]
);

$video_by_ip = (
    select
        @[video_by_ip_grouping_keys_select],
        @[video_metrics]
    from $video_source
    where operator == "beeline"
    and @[video_common_conditions]
    group by @[video_by_ip_grouping_keys]
    having @[video_having]
);

$coordinates_table = $output_root || "_coordinates";
insert into $coordinates_table with truncate
select * from $coordinates;

$radio_by_s2_nonpivoted_output_table = $output_root || "_radio_by_s2_nonpivoted";
insert into $radio_by_s2_nonpivoted_output_table WITH TRUNCATE
select * from $radio_by_s2;

$radio_by_s2_month_nonpivoted_output_table = $output_root || "_radio_by_s2_month_nonpivoted";
insert into $radio_by_s2_month_nonpivoted_output_table WITH TRUNCATE
select * from $radio_by_s2_month;

$radio_by_s2_output_table = $output_root || "_radio_by_s2";
insert into $radio_by_s2_output_table WITH TRUNCATE
reduce $radio_by_s2
on @[radio_by_s2_grouping_keys_select_pivot]
using $radio_by_s2_pivoter(TableRow());

$radio_by_s2_month_output_table = $output_root || "_radio_by_s2_month";
insert into $radio_by_s2_month_output_table WITH TRUNCATE
reduce $radio_by_s2_month
on @[radio_by_s2_month_grouping_keys_select_pivot]
using $radio_by_s2_month_pivoter(TableRow());

$radio_by_s2_month_binary_output_table = $output_root || "_radio_by_s2_month_binary";
insert into $radio_by_s2_month_binary_output_table WITH TRUNCATE
reduce $radio_by_s2_month_binary
on @[radio_by_s2_month_binary_grouping_keys_select_pivot]
using $radio_by_s2_month_binary_pivoter(TableRow());

$radio_by_cell_lac_output_table = $output_root || "_radio_by_cell_lac";
insert into $radio_by_cell_lac_output_table WITH TRUNCATE
select * from $radio_by_cell_lac;

$radio_by_geounit_nonpivoted_output_table = $output_root || "_radio_by_geounit_nonpivoted";
insert into $radio_by_geounit_nonpivoted_output_table WITH TRUNCATE
select * from $radio_by_geounit;

$radio_by_geounit_output_table = $output_root || "_radio_by_geounit";
insert into $radio_by_geounit_output_table WITH TRUNCATE
reduce $radio_by_geounit
on @[radio_by_geounit_grouping_keys_select_pivot]
using $radio_by_geounit_pivoter(TableRow());

$radio_by_filial_nonpivoted_output_table = $output_root || "_radio_by_filial_nonpivoted";
insert into $radio_by_filial_nonpivoted_output_table WITH TRUNCATE
select * from $radio_by_filial;

$radio_by_filial_output_table = $output_root || "_radio_by_filial";
insert into $radio_by_filial_output_table WITH TRUNCATE
reduce $radio_by_filial
on @[radio_by_filial_grouping_keys_select_pivot]
using $radio_by_filial_pivoter(TableRow());

$video_by_s2_nonpivoted_output_table = $output_root || "_video_by_s2_nonpivoted";
insert into $video_by_s2_nonpivoted_output_table WITH TRUNCATE
select * from $video_by_s2;

$video_by_s2_output_table = $output_root || "_video_by_s2";
insert into $video_by_s2_output_table WITH TRUNCATE
reduce $video_by_s2
on @[video_by_s2_grouping_keys_select_pivot]
using $video_by_s2_pivoter(TableRow());

$video_by_cell_lac_output_table = $output_root || "_video_by_cell_lac";
insert into $video_by_cell_lac_output_table WITH TRUNCATE
select * from $video_by_cell_lac;

$video_by_geounit_nonpivoted_output_table = $output_root || "_video_by_geounit_nonpivoted";
insert into $video_by_geounit_nonpivoted_output_table WITH TRUNCATE
select * from $video_by_geounit;

$video_by_geounit_output_table = $output_root || "_video_by_geounit";
insert into $video_by_geounit_output_table WITH TRUNCATE
reduce $video_by_geounit
on @[video_by_geounit_grouping_keys_select_pivot]
using $video_by_geounit_pivoter(TableRow());

$video_by_filial_nonpivoted_output_table = $output_root || "_video_by_filial_nonpivoted";
insert into $video_by_filial_nonpivoted_output_table WITH TRUNCATE
select * from $video_by_filial;

$video_by_filial_output_table = $output_root || "_video_by_filial";
insert into $video_by_filial_output_table WITH TRUNCATE
reduce $video_by_filial
on @[video_by_filial_grouping_keys_select_pivot]
using $video_by_filial_pivoter(TableRow());

$video_by_ip_output_table = $output_root || "_video_by_ip";
insert into $video_by_ip_output_table WITH TRUNCATE
select * from $video_by_ip;
