codegen_vars = dict(
    radio_metrics="""\
CountDistinctEstimate(DeviceID) as radio_devices,
COUNT_IF(SignalStrength is not null) as radio_measurements,
AVG(SignalStrength) as SignalStrength_avg,
PERCENTILE(SignalStrength, 0.05) as SignalStrength_p05,
PERCENTILE(SignalStrength, 0.1) as SignalStrength_p10,
PERCENTILE(SignalStrength, 0.2) as SignalStrength_p20,
PERCENTILE(SignalStrength, 0.3) as SignalStrength_p30,
PERCENTILE(SignalStrength, 0.4) as SignalStrength_p40,
PERCENTILE(SignalStrength, 0.5) as SignalStrength_p50,
PERCENTILE(SignalStrength, 0.6) as SignalStrength_p60,
PERCENTILE(SignalStrength, 0.7) as SignalStrength_p70,
PERCENTILE(SignalStrength, 0.8) as SignalStrength_p80,
PERCENTILE(SignalStrength, 0.9) as SignalStrength_p90,
PERCENTILE(SignalStrength, 0.95) as SignalStrength_p95
""",
    video_metrics="""\
CountDistinctEstimate(DeviceIDVideo) as video_devices,
COUNT_IF(throughput is not null) as video_chunks,
SUM(start) as video_sessions,
SUM(transferSize) / Math::Pow(1024, 3) as traffic_gb,
SUM(refuse) / CAST(SUM(start) as Double) as refuse_share,
(SUM(first_buffer_duration) + SUM(buffer_duration)) / CAST(SUM(start) as Double) as bufferizations_duration_per_view,
(SUM(first_buffer_duration) + SUM(buffer_duration)) / SUM(view_time) * 60.0 as bufferizations_duration_per_min,
(COUNT_IF(buffer_duration is not null) + 1) / CAST(SUM(start) as Double) as bufferizations_per_view,
(COUNT_IF(buffer_duration is not null) + 1) / SUM(view_time) * 60.0 as bufferizations_per_min,
PERCENTILE(first_buffer_duration, 0.05) as first_buffer_duration_p05,
PERCENTILE(first_buffer_duration, 0.1) as first_buffer_duration_p10,
PERCENTILE(first_buffer_duration, 0.2) as first_buffer_duration_p20,
PERCENTILE(first_buffer_duration, 0.3) as first_buffer_duration_p30,
PERCENTILE(first_buffer_duration, 0.4) as first_buffer_duration_p40,
PERCENTILE(first_buffer_duration, 0.5) as first_buffer_duration_p50,
PERCENTILE(first_buffer_duration, 0.6) as first_buffer_duration_p60,
PERCENTILE(first_buffer_duration, 0.7) as first_buffer_duration_p70,
PERCENTILE(first_buffer_duration, 0.8) as first_buffer_duration_p80,
PERCENTILE(first_buffer_duration, 0.9) as first_buffer_duration_p90,
PERCENTILE(first_buffer_duration, 0.95) as first_buffer_duration_p95,
AVG(first_buffer_throughput) as first_buffer_throughput_avg,
PERCENTILE(first_buffer_throughput, 0.05) as first_buffer_throughput_p05,
PERCENTILE(first_buffer_throughput, 0.1) as first_buffer_throughput_p10,
PERCENTILE(first_buffer_throughput, 0.2) as first_buffer_throughput_p20,
PERCENTILE(first_buffer_throughput, 0.3) as first_buffer_throughput_p30,
PERCENTILE(first_buffer_throughput, 0.4) as first_buffer_throughput_p40,
PERCENTILE(first_buffer_throughput, 0.5) as first_buffer_throughput_p50,
PERCENTILE(first_buffer_throughput, 0.6) as first_buffer_throughput_p60,
PERCENTILE(first_buffer_throughput, 0.7) as first_buffer_throughput_p70,
PERCENTILE(first_buffer_throughput, 0.8) as first_buffer_throughput_p80,
PERCENTILE(first_buffer_throughput, 0.9) as first_buffer_throughput_p90,
PERCENTILE(first_buffer_throughput, 0.95) as first_buffer_throughput_p95,
AVG(quality) as quality_avg,
PERCENTILE(quality, 0.05) as quality_p05,
PERCENTILE(quality, 0.1) as quality_p10,
PERCENTILE(quality, 0.2) as quality_p20,
PERCENTILE(quality, 0.3) as quality_p30,
PERCENTILE(quality, 0.4) as quality_p40,
PERCENTILE(quality, 0.5) as quality_p50,
PERCENTILE(quality, 0.6) as quality_p60,
PERCENTILE(quality, 0.7) as quality_p70,
PERCENTILE(quality, 0.8) as quality_p80,
PERCENTILE(quality, 0.9) as quality_p90,
PERCENTILE(quality, 0.95) as quality_p95,
AVG(throughput) as throughput_avg,
PERCENTILE(throughput, 0.05) as throughput_p05,
PERCENTILE(throughput, 0.1) as throughput_p10,
PERCENTILE(throughput, 0.2) as throughput_p20,
PERCENTILE(throughput, 0.3) as throughput_p30,
PERCENTILE(throughput, 0.4) as throughput_p40,
PERCENTILE(throughput, 0.5) as throughput_p50,
PERCENTILE(throughput, 0.6) as throughput_p60,
PERCENTILE(throughput, 0.7) as throughput_p70,
PERCENTILE(throughput, 0.8) as throughput_p80,
PERCENTILE(throughput, 0.9) as throughput_p90,
PERCENTILE(throughput, 0.95) as throughput_p95
""",
    radio_common_conditions="""\
SignalStrength >= -110.0
and SignalStrength <= 0.0
and CellType != "DEFAULT"
""",
    video_common_conditions='NetworkType != "DEFAULT"',
    radio_having="CountDistinctEstimate(DeviceID) >= 10",
    video_having="CountDistinctEstimate(DeviceIDVideo) >= 10",
    radio_by_s2_grouping_keys="s2_level, s2_value, operator, CellType, $getFielddate(`timestamp`) as fielddate",
    radio_by_s2_month_grouping_keys="s2_level, s2_value, operator, CellType",
    radio_by_s2_month_binary_grouping_keys="s2_level, s2_value, operator, CellType",
    radio_by_cell_lac_grouping_keys="Lac, CellID, CellType, $getFielddate(`timestamp`) as fielddate",
    radio_by_filial_grouping_keys="$getFielddate(`timestamp`) as fielddate, filial, aggregation_type, operator, CellType",
    radio_by_geounit_grouping_keys="$getFielddate(`timestamp`) as fielddate, geounit, operator, CellType",
    video_by_s2_grouping_keys="s2_level, s2_value, operator, NetworkType, $getFielddate(`timestamp`) as fielddate",
    video_by_cell_lac_grouping_keys="Lac, CellID, NetworkType, $getFielddate(`timestamp`) as fielddate",
    video_by_geounit_grouping_keys="$getFielddate(`timestamp`) as fielddate, geounit, operator, NetworkType",
    video_by_filial_grouping_keys="$getFielddate(`timestamp`) as fielddate, filial, aggregation_type, operator, NetworkType",
    video_by_ip_grouping_keys="ip, NetworkType, $getFielddate(`timestamp`) as fielddate",
    columns_types={
        # here go keys
        "aggregation_type": "String?",
        "CellType": "String?",
        "fielddate": "String?",
        "filial": "String?",
        "geounit": "String?",
        "NetworkType": "String?",
        "operator": "String?",
        "s2_level": "String",
        "s2_value": "Uint64?",
        # here go values
        "bufferizations_duration_per_min": "Double?",
        "bufferizations_duration_per_view": "Double?",
        "bufferizations_per_min": "Double?",
        "bufferizations_per_view": "Double?",
        "first_buffer_duration_p05": "Double?",
        "first_buffer_duration_p10": "Double?",
        "first_buffer_duration_p20": "Double?",
        "first_buffer_duration_p30": "Double?",
        "first_buffer_duration_p40": "Double?",
        "first_buffer_duration_p50": "Double?",
        "first_buffer_duration_p60": "Double?",
        "first_buffer_duration_p70": "Double?",
        "first_buffer_duration_p80": "Double?",
        "first_buffer_duration_p90": "Double?",
        "first_buffer_duration_p95": "Double?",
        "first_buffer_throughput_avg": "Double?",
        "first_buffer_throughput_p05": "Double?",
        "first_buffer_throughput_p10": "Double?",
        "first_buffer_throughput_p20": "Double?",
        "first_buffer_throughput_p30": "Double?",
        "first_buffer_throughput_p40": "Double?",
        "first_buffer_throughput_p50": "Double?",
        "first_buffer_throughput_p60": "Double?",
        "first_buffer_throughput_p70": "Double?",
        "first_buffer_throughput_p80": "Double?",
        "first_buffer_throughput_p90": "Double?",
        "first_buffer_throughput_p95": "Double?",
        "quality_avg": "Double?",
        "quality_p05": "Double?",
        "quality_p10": "Double?",
        "quality_p20": "Double?",
        "quality_p30": "Double?",
        "quality_p40": "Double?",
        "quality_p50": "Double?",
        "quality_p60": "Double?",
        "quality_p70": "Double?",
        "quality_p80": "Double?",
        "quality_p90": "Double?",
        "quality_p95": "Double?",
        "radio_devices": "Uint64?",
        "radio_measurements": "Uint64?",
        "refuse_share": "Double?",
        "SignalStrength_avg": "Double?",
        "SignalStrength_p05": "Double?",
        "SignalStrength_p10": "Double?",
        "SignalStrength_p20": "Double?",
        "SignalStrength_p30": "Double?",
        "SignalStrength_p40": "Double?",
        "SignalStrength_p50": "Double?",
        "SignalStrength_p60": "Double?",
        "SignalStrength_p70": "Double?",
        "SignalStrength_p80": "Double?",
        "SignalStrength_p90": "Double?",
        "SignalStrength_p95": "Double?",
        "throughput_avg": "Double?",
        "throughput_p05": "Double?",
        "throughput_p10": "Double?",
        "throughput_p20": "Double?",
        "throughput_p30": "Double?",
        "throughput_p40": "Double?",
        "throughput_p50": "Double?",
        "throughput_p60": "Double?",
        "throughput_p70": "Double?",
        "throughput_p80": "Double?",
        "throughput_p90": "Double?",
        "throughput_p95": "Double?",
        "traffic_gb": "Double?",
        "video_chunks": "Double?",
        "video_devices": "Double?",
        "video_sessions": "Double?",
    },
    pivoter_stub="""\
$@[d_type]_by_@[a_type]_input_type = Struct<
    @[input_type_signature]
>;

$@[d_type]_by_@[a_type]_output_type = Struct<
    @[output_type_signature]
>;

$@[d_type]_by_@[a_type]_input_keys = @[keys];

$@[d_type]_by_@[a_type]_input_metrics = @[metrics];

$@[d_type]_by_@[a_type]_pivoter = Python::Pivoter(
    Callable<(List<String?>, List<String?>, Utf8?)->Callable<
        (Tuple<@[input_keys_types]>, Stream<$@[d_type]_by_@[a_type]_input_type>)->Stream<$@[d_type]_by_@[a_type]_output_type>
    >>, FileContent("beeline_pivot.py")
)($@[d_type]_by_@[a_type]_input_keys, $@[d_type]_by_@[a_type]_input_metrics, @[pivoter_type]);
""",
    yt_format_string="<columns=[{}];missing_value_mode=print_sentinel;enable_column_names_header=true>schemaful_dsv",
)
