from yt.yson.yson_types import YsonEntity
from collections import defaultdict


def _get_position(x, lst):
    merged_lst = sorted([x] + lst, reverse=True)
    p1 = merged_lst.index(x) + 1
    p2 = len(merged_lst) - merged_lst[::-1].index(x)
    return (p1 + p2) / 2.0


class Pivoter:
    def __init__(self, grouping_keys, value_keys, type_="normal"):
        self.grouping_keys = [x.decode("utf8") for x in grouping_keys]
        self.value_keys = [x.decode("utf8") for x in value_keys]
        self.type_ = type_

    def __call__(self, _, recs):
        grouping_keys = self.grouping_keys
        value_keys = self.value_keys
        row_dict = defaultdict(lambda: defaultdict(lambda: defaultdict(list)))
        for rec in recs:
            tup = tuple([getattr(rec, k, None) for k in grouping_keys])
            if rec.operator == b"beeline":
                for k in value_keys:
                    row_dict[tup]["own"][k] = getattr(rec, k, None)
            else:
                for k in value_keys:
                    row_dict[tup]["other"][k].append(getattr(rec, k, None))
        for tup in sorted(row_dict):
            row = dict(zip(grouping_keys, tup))
            own = row_dict[tup]["own"]
            other = row_dict[tup]["other"]
            for key in value_keys:
                if isinstance(own[key], (list, YsonEntity)):
                    row[key] = None
                else:
                    row[key] = own[key]
                other_lst = [
                    x
                    for x in other[key]
                    if not isinstance(x, (list, YsonEntity)) and x is not None
                ]
                if self.type_ == "normal":
                    if other_lst:
                        row["{}_max".format(key)] = max(other_lst)
                        row["{}_min".format(key)] = min(other_lst)
                        if row[key] is not None:
                            row["{}_position".format(key)] = _get_position(
                                row[key], other_lst
                            )
                        else:
                            row["{}_position".format(key)] = None
                    else:
                        row["{}_max".format(key)] = None
                        row["{}_min".format(key)] = None
                        row["{}_position".format(key)] = None
                elif self.type_ == "binary":
                    if other_lst:
                        row["{}_other".format(key)] = True
                    else:
                        row["{}_other".format(key)] = False
            yield row
