from yt.yson.yson_types import YsonEntity
from collections import defaultdict


def _get_position(x, lst):
    merged_lst = sorted([x] + lst, reverse=True)
    p1 = merged_lst.index(x) + 1
    p2 = len(merged_lst) - merged_lst[::-1].index(x)
    return (p1 + p2) / 2.0


def reducer(key, recs):
    grouping_keys = ["fielddate", "CellType", "s2_level", "s2_value"]
    value_keys = [
        "SignalStrength_avg",
        "SignalStrength_p05",
        "SignalStrength_p10",
        "SignalStrength_p20",
        "SignalStrength_p30",
        "SignalStrength_p40",
        "SignalStrength_p50",
        "SignalStrength_p60",
        "SignalStrength_p70",
        "SignalStrength_p80",
        "SignalStrength_p90",
        "SignalStrength_p95",
        "radio_devices",
        "radio_measurements",
    ]
    row_dict = defaultdict(lambda: defaultdict(lambda: defaultdict(list)))
    for rec in recs:
        tup = tuple([getattr(rec, k, None) for k in grouping_keys])
        if rec.operator == b"beeline":
            for k in value_keys:
                row_dict[tup]["own"][k] = getattr(rec, k, None)
        else:
            for k in value_keys:
                row_dict[tup]["other"][k].append(getattr(rec, k, None))
    for tup in sorted(row_dict):
        row = dict(zip(grouping_keys, tup))
        own = row_dict[tup]["own"]
        other = row_dict[tup]["other"]
        for key in value_keys:
            if isinstance(own[key], (list, YsonEntity)):
                row[key] = None
            else:
                row[key] = own[key]
            other_lst = [
                x
                for x in other[key]
                if not isinstance(x, (list, YsonEntity)) and x is not None
            ]
            if other_lst:
                row["{}_max".format(key)] = max(other_lst)
                row["{}_min".format(key)] = min(other_lst)
                if row[key] is not None:
                    row["{}_position".format(key)] = _get_position(row[key], other_lst)
            else:
                row["{}_max".format(key)] = None
                row["{}_min".format(key)] = None
                row["{}_position".format(key)] = None
        yield row
