from yt.yson.yson_types import YsonEntity
from collections import defaultdict


def _get_position(x, lst):
    merged_lst = sorted([x] + lst, reverse=True)
    p1 = merged_lst.index(x) + 1
    p2 = len(merged_lst) - merged_lst[::-1].index(x)
    return (p1 + p2) / 2.0


def reducer(key, recs):
    grouping_keys = ["fielddate", "NetworkType", "s2_level", "s2_value"]
    value_keys = [
        "bufferizations_duration_per_min",
        "bufferizations_duration_per_view",
        "bufferizations_per_min",
        "bufferizations_per_view",
        "first_buffer_duration_p05",
        "first_buffer_duration_p10",
        "first_buffer_duration_p20",
        "first_buffer_duration_p30",
        "first_buffer_duration_p40",
        "first_buffer_duration_p50",
        "first_buffer_duration_p60",
        "first_buffer_duration_p70",
        "first_buffer_duration_p80",
        "first_buffer_duration_p90",
        "first_buffer_duration_p95",
        "first_buffer_throughput_p05",
        "first_buffer_throughput_p10",
        "first_buffer_throughput_p20",
        "first_buffer_throughput_p30",
        "first_buffer_throughput_p40",
        "first_buffer_throughput_p50",
        "first_buffer_throughput_p60",
        "first_buffer_throughput_p70",
        "first_buffer_throughput_p80",
        "first_buffer_throughput_p90",
        "first_buffer_throughput_p95",
        "quality_p05",
        "quality_p10",
        "quality_p20",
        "quality_p30",
        "quality_p40",
        "quality_p50",
        "quality_p60",
        "quality_p70",
        "quality_p80",
        "quality_p90",
        "quality_p95",
        "refuse_share",
        "throughput_p05",
        "throughput_p10",
        "throughput_p20",
        "throughput_p30",
        "throughput_p40",
        "throughput_p50",
        "throughput_p60",
        "throughput_p70",
        "throughput_p80",
        "throughput_p90",
        "throughput_p95",
        "traffic_gb",
        "video_chunks",
        "video_devices",
        "video_sessions",
    ]
    row_dict = defaultdict(lambda: defaultdict(lambda: defaultdict(list)))
    for rec in recs:
        tup = tuple([getattr(rec, k, None) for k in grouping_keys])
        if rec.operator == b"beeline":
            for k in value_keys:
                row_dict[tup]["own"][k] = getattr(rec, k, None)
        else:
            for k in value_keys:
                row_dict[tup]["other"][k].append(getattr(rec, k, None))
    for tup in sorted(row_dict):
        row = dict(zip(grouping_keys, tup))
        own = row_dict[tup]["own"]
        other = row_dict[tup]["other"]
        for key in value_keys:
            if isinstance(own[key], (list, YsonEntity)):
                row[key] = None
            else:
                row[key] = own[key]
            other_lst = [
                x
                for x in other[key]
                if not isinstance(x, (list, YsonEntity)) and x is not None
            ]
            if other_lst:
                row["{}_max".format(key)] = max(other_lst)
                row["{}_min".format(key)] = min(other_lst)
                if row[key] is not None:
                    row["{}_position".format(key)] = _get_position(row[key], other_lst)
            else:
                row["{}_max".format(key)] = None
                row["{}_min".format(key)] = None
                row["{}_position".format(key)] = None
        yield row
