$thresholds = {
    "Moscow": AsTuple(217000000000, 78100000),
    "St.-Peterburg": AsTuple(78200000000, 32500000),
    "Krasnodar": AsTuple(18800000000, 6250000),
    "Rostov-na-Donu": AsTuple(13100000000, 5490000),
    "Ekaterinburg": AsTuple(11900000000, 5310000),
    "Samara": AsTuple(11500000000, 5620000),
    "Novosibirsk": AsTuple(11100000000, 5560000),
    "Kazan": AsTuple(10700000000, 5090000),
    "N/Novgorod": AsTuple(9980000000, 5120000),
    "Ufa": AsTuple(9930000000, 4130000),
    "Chelyabinsk": AsTuple(8390000000, 4150000),
    "Voronezh": AsTuple(7090000000, 3200000),
    "Krasnoyarsk": AsTuple(6390000000, 3180000),
    "Saratov": AsTuple(6140000000, 3380000),
    "Perm": AsTuple(6120000000, 3500000),
    "Stavropol": AsTuple(5660000000, 1930000),
    "Volgograd": AsTuple(5240000000, 2560000),
    "Tula": AsTuple(4820000000, 2480000),
    "Tyumen": AsTuple(4730000000, 2530000),
    "Kemerovo": AsTuple(4490000000, 2490000),
    "Other": AsTuple(94909600000, 42672000)
};

$video_by_filial = "//home/videoquality/vh_analytics/mma-3568-tele2/beeline_exports/beeline_" || $month || "/beeline_" || $month || "_video_by_filial_nonpivoted";
$radio_by_filial = "//home/videoquality/vh_analytics/mma-3568-tele2/beeline_exports/beeline_" || $month || "/beeline_" || $month || "_radio_by_filial_nonpivoted";

$stripDot = Python::strip_dot(
    Callable<(String?)->String?>, @@
def strip_dot(s):
    s = s.decode("utf8")
    sp = s.split(".")
    jnd = ".".join(sp[1:])
    return jnd.encode("utf8")
@@
);

$video_tmp = (
    select
        filial,
        sum(video_sessions) as video_sessions
    from (
        select
            IF(
                DictContains($thresholds, $stripDot(filial)),
                unwrap($stripDot(filial)),
                "Other"
            ) as filial,
            video_sessions
        from $video_by_filial
    )
    group by filial
);

$radio_tmp = (
    select
        filial,
        SUM(radio_measurements) as radio_measurements
    from (
        select
            IF(
                DictContains($thresholds, $stripDot(filial)),
                unwrap($stripDot(filial)),
                "Other"
            ) as filial,
            radio_measurements
        from $radio_by_filial
    )
    group by filial
);

$joined = (
    select v.filial ?? r.filial as filial,
    radio_measurements ?? 0 as radio_measurements,
    video_sessions ?? 0 as video_sessions
    from $video_tmp as v
    full join $radio_tmp as r using (filial)
);

$add_thresholds = (
    select
        t.*,
        $thresholds[filial].0 as radio_measurements_threshold,
        radio_measurements >= $thresholds[filial].0 as radio_measurements_threshold_pass,
        radio_measurements / cast($thresholds[filial].0 as Double) as radio_measurements_share,
        $thresholds[filial].1 as video_sessions_threshold,
        video_sessions >= $thresholds[filial].1 as video_sessions_threshold_pass,
        video_sessions / cast($thresholds[filial].1 as Double) as video_sessions_share,
    from $joined as t
);

select * from $add_thresholds
order by radio_measurements desc;
