#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import argparse
import datetime
import boto3

def get_date(key):
    return key.split("/")[0].split("_")[-1]


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--s3_host", default="s3.mds.yandex.net")
    parser.add_argument("--threshold", default="2021-07")
    args = parser.parse_args()

    session = boto3.session.Session(
        aws_access_key_id=os.environ["ACCESS_KEY_ID"],
        aws_secret_access_key=os.environ["ACCESS_KEY"],
    )
    s3 = session.client(service_name="s3", endpoint_url=f"https://{args.s3_host}")
    objs = s3.list_objects(Bucket="yaexports")["Contents"]

    bad = [
        x for x in objs
        if len(get_date(x["Key"])) == 7 and get_date(x["Key"]) < args.threshold
    ]
    good = [
        x for x in objs
        if not (len(get_date(x["Key"])) == 7 and get_date(x["Key"]) < args.threshold)
    ]
    import IPython; IPython.embed()
    for x in bad:
        s3.delete_object(Key=x["Key"], Bucket="yaexports")


if __name__ == "__main__":
    main()
