#!/usr/bin/env python
# -*- coding: utf-8 -*-
import sys
import os
import codecs
import json
import argparse
import datetime

default_root = "//home/videoquality/vh_analytics/mma-3568-tele2/new_algo_test"

default_output_root = "//home/videoquality/vh_analytics/mma-3568-tele2/beeline_exports"

config_stub = """
date_from: {date_from}
date_to: {date_to}
export_name: {export_name}
reduced_root: //home/videoquality/vh_analytics/mma-3568-tele2/reduced
output_root: //home/videoquality/vh_analytics/mma-3568-tele2/beeline_exports
"""


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--month")
    parser.add_argument("--root")
    parser.add_argument("--output_root")
    parser.add_argument("--export_name")
    parser.add_argument("--output_json", default="output.json")
    parser.add_argument("--output_yaml", default="output.yaml")
    args = parser.parse_args()

    first_day = datetime.datetime.strptime(args.month + "-01", "%Y-%m-%d").date()
    last_day = first_day + datetime.timedelta(days=32)
    last_day -= datetime.timedelta(days=last_day.day)

    config = config_stub.format(
        date_from=str(first_day),
        date_to=str(last_day),
        root=args.root or default_root,
        export_name=args.export_name or "beeline_" + args.month,
        output_root=args.output_root or default_output_root,
    )

    output_json = {"date_from": str(first_day), "date_to": str(last_day)}

    with open(args.output_yaml, "w") as f:
        f.write(config)

    with open(args.output_json, "w") as f:
        json.dump(output_json, f, indent=4)


if __name__ == "__main__":
    main()
