use hahn;

$source_table = "//home/videoquality/vh_analytics/mma-3568-tele2/new_algo_test/2020-04-01_2020-04-30/reduced1";

$processReduced = ($row) -> {
    $base = RemoveMember($row, "s2_p13");
    $base = RemoveMember($base, "s2_p14");
    $base = RemoveMember($base, "s2_p15");
    return AsList(
        ExpandStruct(
            $base, "s2_p13" as s2_level, $row.s2_p13 as s2_value
        ),
        ExpandStruct(
            $base, "s2_p14" as s2_level, $row.s2_p14 as s2_value
        ),
        ExpandStruct(
            $base, "s2_p15" as s2_level, $row.s2_p15 as s2_value
        ),
    )
};

$processed = (process $source_table using $processReduced(TableRow()));

$with_geounits_pre = (
    select s.*, geounits as geounit
    from $source_table as s
    inner join `//home/videolog/cell_id_to_geounit_schematized` as g using (s2_p13)
);

$with_geounits = (
    select
        *
    from $with_geounits_pre
    flatten list by geounit
);

$with_filials = (
    select s.*, filial, aggregation_type
    from $with_geounits as s
    inner join `//home/videolog/geounits_types` as g using (geounit)
);

$fielddateFormat = DateTime::Format("%Y-%m-%d");
$getFielddate = ($ts) -> {
    $ts = CAST($ts as Uint32);
    $tm = AddTimezone(DateTime::FromSeconds($ts), "Europe/Moscow");
    RETURN $fielddateFormat($tm)
};

$radio_by_s2 = (
    select
        fielddate, -- упс
        s2_level,
        s2_value,
        operator,
        CellType,
        --- radio metrics
        CountDistinctEstimate(DeviceID) as radio_devices,
        COUNT_IF(SignalStrength is not null) as radio_measurements,
        AVG(SignalStrength) as SignalStrength_avg,
        PERCENTILE(SignalStrength, 0.05) as SignalStrength_p05,
        PERCENTILE(SignalStrength, 0.1) as SignalStrength_p10,
        PERCENTILE(SignalStrength, 0.2) as SignalStrength_p20,
        PERCENTILE(SignalStrength, 0.3) as SignalStrength_p30,
        PERCENTILE(SignalStrength, 0.4) as SignalStrength_p40,
        PERCENTILE(SignalStrength, 0.5) as SignalStrength_p50,
        PERCENTILE(SignalStrength, 0.6) as SignalStrength_p60,
        PERCENTILE(SignalStrength, 0.7) as SignalStrength_p70,
        PERCENTILE(SignalStrength, 0.8) as SignalStrength_p80,
        PERCENTILE(SignalStrength, 0.9) as SignalStrength_p90,
        PERCENTILE(SignalStrength, 0.95) as SignalStrength_p95
        --- end radio metrics
    from $processed
    where s2_value is not null --and SignalStrength not in (-51, -113, -141, 2147483647)
    and SignalStrength >= -110.0
    and SignalStrength <= 0.0
    and CellType != "DEFAULT"
    group by s2_level, s2_value, operator, CellType, $getFielddate(`timestamp`) as fielddate
    having CountDistinctEstimate(DeviceID) >= 10
);

$radio_by_cell_lac = (
    select
        fielddate, Lac, CellID, CellType,
        --- radio metrics
        CountDistinctEstimate(DeviceID) as radio_devices,
        COUNT_IF(SignalStrength is not null) as radio_measurements,
        AVG(SignalStrength) as SignalStrength_avg,
        PERCENTILE(SignalStrength, 0.05) as SignalStrength_p05,
        PERCENTILE(SignalStrength, 0.1) as SignalStrength_p10,
        PERCENTILE(SignalStrength, 0.2) as SignalStrength_p20,
        PERCENTILE(SignalStrength, 0.3) as SignalStrength_p30,
        PERCENTILE(SignalStrength, 0.4) as SignalStrength_p40,
        PERCENTILE(SignalStrength, 0.5) as SignalStrength_p50,
        PERCENTILE(SignalStrength, 0.6) as SignalStrength_p60,
        PERCENTILE(SignalStrength, 0.7) as SignalStrength_p70,
        PERCENTILE(SignalStrength, 0.8) as SignalStrength_p80,
        PERCENTILE(SignalStrength, 0.9) as SignalStrength_p90,
        PERCENTILE(SignalStrength, 0.95) as SignalStrength_p95
        --- end radio metrics
    from $source_table
    where operator == "beeline"
    and SignalStrength >= -110.0
    and SignalStrength <= 0.0
    and CellType != "DEFAULT"
    group by Lac, CellID, CellType, $getFielddate(`timestamp`) as fielddate
    having CountDistinctEstimate(DeviceID) >= 10
);

$radio_by_geounit = (
    select
        fielddate,
        geounit,
        operator,
        CellType,
        --- radio metrics
        CountDistinctEstimate(DeviceID) as radio_devices,
        COUNT_IF(SignalStrength is not null) as radio_measurements,
        AVG(SignalStrength) as SignalStrength_avg,
        PERCENTILE(SignalStrength, 0.05) as SignalStrength_p05,
        PERCENTILE(SignalStrength, 0.1) as SignalStrength_p10,
        PERCENTILE(SignalStrength, 0.2) as SignalStrength_p20,
        PERCENTILE(SignalStrength, 0.3) as SignalStrength_p30,
        PERCENTILE(SignalStrength, 0.4) as SignalStrength_p40,
        PERCENTILE(SignalStrength, 0.5) as SignalStrength_p50,
        PERCENTILE(SignalStrength, 0.6) as SignalStrength_p60,
        PERCENTILE(SignalStrength, 0.7) as SignalStrength_p70,
        PERCENTILE(SignalStrength, 0.8) as SignalStrength_p80,
        PERCENTILE(SignalStrength, 0.9) as SignalStrength_p90,
        PERCENTILE(SignalStrength, 0.95) as SignalStrength_p95
        --- end radio metrics
    from $with_geounits 
    where SignalStrength >= -110.0
    and SignalStrength <= 0.0
    and CellType != "DEFAULT"
    group by $getFielddate(`timestamp`) as fielddate, geounit, operator, CellType
    having CountDistinctEstimate(DeviceID) >= 10
);

$radio_by_filial = (
    select
        fielddate,
        filial,
        aggregation_type,
        operator,
        CellType,
        --- radio metrics
        CountDistinctEstimate(DeviceID) as radio_devices,
        COUNT_IF(SignalStrength is not null) as radio_measurements,
        AVG(SignalStrength) as SignalStrength_avg,
        PERCENTILE(SignalStrength, 0.05) as SignalStrength_p05,
        PERCENTILE(SignalStrength, 0.1) as SignalStrength_p10,
        PERCENTILE(SignalStrength, 0.2) as SignalStrength_p20,
        PERCENTILE(SignalStrength, 0.3) as SignalStrength_p30,
        PERCENTILE(SignalStrength, 0.4) as SignalStrength_p40,
        PERCENTILE(SignalStrength, 0.5) as SignalStrength_p50,
        PERCENTILE(SignalStrength, 0.6) as SignalStrength_p60,
        PERCENTILE(SignalStrength, 0.7) as SignalStrength_p70,
        PERCENTILE(SignalStrength, 0.8) as SignalStrength_p80,
        PERCENTILE(SignalStrength, 0.9) as SignalStrength_p90,
        PERCENTILE(SignalStrength, 0.95) as SignalStrength_p95
        --- end radio metrics
    from $with_filials
    where SignalStrength >= -110.0
    and SignalStrength <= 0.0
    and CellType != "DEFAULT"
    group by $getFielddate(`timestamp`) as fielddate, filial, aggregation_type, operator, CellType
    having CountDistinctEstimate(DeviceID) >= 10
);

insert into `//home/videoquality/vh_analytics/mma-3568-tele2/beeline_exports/april/by_s2` WITH TRUNCATE 
select * from $radio_by_s2;

insert into `//home/videoquality/vh_analytics/mma-3568-tele2/beeline_exports/april/by_cell_lac` WITH TRUNCATE 
select * from $radio_by_cell_lac;

insert into `//home/videoquality/vh_analytics/mma-3568-tele2/beeline_exports/april/by_geounit` WITH TRUNCATE 
select * from $radio_by_geounit;

insert into `//home/videoquality/vh_analytics/mma-3568-tele2/beeline_exports/april/by_filial` WITH TRUNCATE 
select * from $radio_by_filial;