use hahn;
pragma yt.DefaultMaxJobFails = "1";

$source_table = "//home/videoquality/vh_analytics/mma-3568-tele2/beeline_exports/april/by_s2";

$input_type = Struct<
    CellType: String?,
    SignalStrength_avg: Double?,
    SignalStrength_p05: Double?,
    SignalStrength_p10: Double?,
    SignalStrength_p20: Double?,
    SignalStrength_p30: Double?,
    SignalStrength_p40: Double?,
    SignalStrength_p50: Double?,
    SignalStrength_p60: Double?,
    SignalStrength_p70: Double?,
    SignalStrength_p80: Double?,
    SignalStrength_p90: Double?,
    SignalStrength_p95: Double?,
    fielddate: String?,
    operator: String?,
    radio_devices: Uint64?,
    radio_measurements: Uint64,
    s2_level: String,
    s2_value: Uint64?,
>;

$output_type = Struct<
    fielddate: String?,
    CellType: String?,
    s2_level: String?,
    s2_value:Uint64?,
    SignalStrength_avg: Double?,
    SignalStrength_avg_min: Double?,
    SignalStrength_avg_max: Double?,
    SignalStrength_avg_position: Double?,
    SignalStrength_p05: Double?,
    SignalStrength_p05_min: Double?,
    SignalStrength_p05_max: Double?,
    SignalStrength_p05_position: Double?,
    SignalStrength_p10: Double?,
    SignalStrength_p10_min: Double?,
    SignalStrength_p10_max: Double?,
    SignalStrength_p10_position: Double?,
    SignalStrength_p20: Double?,
    SignalStrength_p20_min: Double?,
    SignalStrength_p20_max: Double?,
    SignalStrength_p20_position: Double?,
    SignalStrength_p30: Double?,
    SignalStrength_p30_min: Double?,
    SignalStrength_p30_max: Double?,
    SignalStrength_p30_position: Double?,
    SignalStrength_p40: Double?,
    SignalStrength_p40_min: Double?,
    SignalStrength_p40_max: Double?,
    SignalStrength_p40_position: Double?,
    SignalStrength_p50: Double?,
    SignalStrength_p50_min: Double?,
    SignalStrength_p50_max: Double?,
    SignalStrength_p50_position: Double?,
    SignalStrength_p60: Double?,
    SignalStrength_p60_min: Double?,
    SignalStrength_p60_max: Double?,
    SignalStrength_p60_position: Double?,
    SignalStrength_p70: Double?,
    SignalStrength_p70_min: Double?,
    SignalStrength_p70_max: Double?,
    SignalStrength_p70_position: Double?,
    SignalStrength_p80: Double?,
    SignalStrength_p80_min: Double?,
    SignalStrength_p80_max: Double?,
    SignalStrength_p80_position: Double?,
    SignalStrength_p90: Double?,
    SignalStrength_p90_min: Double?,
    SignalStrength_p90_max: Double?,
    SignalStrength_p90_position: Double?,
    SignalStrength_p95: Double?,
    SignalStrength_p95_min: Double?,
    SignalStrength_p95_max: Double?,
    SignalStrength_p95_position: Double?,
    radio_devices: Double?,
    radio_devices_min: Double?,
    radio_devices_max: Double?,
    radio_devices_position: Double?,
    radio_measurements: Double?,
    radio_measurements_min: Double?,
    radio_measurements_max: Double?,
    radio_measurements_position: Double?
>;

$reducer = Python::reducer(
    Callable<(Tuple<String?, String?, String?, Uint64?>, Stream<$input_type>)->Stream<$output_type>>, FileContent("beeline_pivot_radio.py")
);

insert into `//home/videoquality/vh_analytics/mma-3568-tele2/beeline_exports/april/radio_by_s2_pivoted` WITH TRUNCATE 
reduce $source_table
on fielddate, CellType, s2_level, s2_value
using $reducer(TableRow());