#!/usr/bin/env python
# -*- coding: utf-8 -*-
import argparse
import subprocess
import yt.wrapper as yt


def get_sorting(schema_key):
    return (
        0 if "sort_order" in schema_key else 1,
        0 if schema_key["type"] == "string" else 1,
        schema_key["type"],
        schema_key["name"],
    )


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("table")
    args = parser.parse_args()

    schema = yt.get_attribute(args.table, "schema")
    sschema = sorted(schema, key=get_sorting)
    columns = ";".join(x["name"] for x in sschema)
    format_string = "<columns=[{}];missing_value_mode=print_sentinel;enable_column_names_header=true>schemaful_dsv".format(
        columns
    )

    fn = args.table.split("/")[-1] + ".tsv"
    stdout = open(fn, "wb")
    subprocess.call(
        ["yt", "read", "--format", format_string, args.table], stdout=stdout
    )
    stdout.close()


if __name__ == "__main__":
    main()
